/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.runtime;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.api.scala.runtime.ScalaSpecialTypesSerializerTestInstance;
import org.apache.flink.api.scala.typeutils.TraversableSerializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u001f\t\tCK]1wKJ\u001c\u0018M\u00197f'\u0016\u0014\u0018.\u00197ju\u0016\u0014H+Z:u\u0013:\u001cH/\u00198dK*\u00111\u0001B\u0001\beVtG/[7f\u0015\t)a!A\u0003tG\u0006d\u0017M\u0003\u0002\b\u0011\u0005\u0019\u0011\r]5\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001!\u0006\u0002\u0011/M\u0011\u0001!\u0005\t\u0004%M)R\"\u0001\u0002\n\u0005Q\u0011!aJ*dC2\f7\u000b]3dS\u0006dG+\u001f9fgN+'/[1mSj,'\u000fV3ti&s7\u000f^1oG\u0016\u0004\"AF\f\r\u0001\u0011)\u0001\u0004\u0001b\u00013\t\tA+\u0005\u0002\u001b?A\u00111$H\u0007\u00029)\tQ!\u0003\u0002\u001f9\t9aj\u001c;iS:<\u0007CA\u000e!\u0013\t\tCDA\u0002B]fD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bcA\u0013++5\taE\u0003\u0002(Q\u0005IA/\u001f9fkRLGn\u001d\u0006\u0003S\u0019\taaY8n[>t\u0017BA\u0016'\u00059!\u0016\u0010]3TKJL\u0017\r\\5{KJD\u0001\"\f\u0001\u0003\u0002\u0003\u0006IAL\u0001\nif\u0004Xm\u00117bgN\u00042a\f\u001a\u0016\u001d\tY\u0002'\u0003\u000229\u00051\u0001K]3eK\u001aL!a\r\u001b\u0003\u000b\rc\u0017m]:\u000b\u0005Eb\u0002\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\r1,gn\u001a;i!\tY\u0002(\u0003\u0002:9\t\u0019\u0011J\u001c;\t\u0011m\u0002!\u0011!Q\u0001\nq\n\u0001\u0002^3ti\u0012\u000bG/\u0019\t\u00047u*\u0012B\u0001 \u001d\u0005\u0015\t%O]1z\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u0019a\u0014N\\5u}Q)!i\u0011#F\rB\u0019!\u0003A\u000b\t\u000b\rz\u0004\u0019\u0001\u0013\t\u000b5z\u0004\u0019\u0001\u0018\t\u000bYz\u0004\u0019A\u001c\t\u000bmz\u0004\u0019\u0001\u001f\t\u000b!\u0003A\u0011I%\u0002\u000fQ,7\u000f^!mYR\t!\n\u0005\u0002\u001c\u0017&\u0011A\n\b\u0002\u0005+:LG\u000f\u000b\u0002H\u001dB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bD\u0001\u0006UVt\u0017\u000e^\u0005\u0003'B\u0013A\u0001V3ti\")Q\u000b\u0001C\u0001\u0013\u00069B/Z:u)J\fg/\u001a:tC\ndW\rR3fa\u000e{\u0007/\u001f\u0015\u0003):CQ\u0001\u0017\u0001\u0005B%\u000bq\u0002^3ti&s7\u000f^1oi&\fG/\u001a\u0015\u0003/:CQa\u0017\u0001\u0005Rq\u000b!\u0002Z3fa\u0016\u000bX/\u00197t)\u0011QUL\u00193\t\u000byS\u0006\u0019A0\u0002\u000f5,7o]1hKB\u0011q\u0006Y\u0005\u0003CR\u0012aa\u0015;sS:<\u0007\"B2[\u0001\u0004)\u0012AB:i_VdG\rC\u0003f5\u0002\u0007Q#\u0001\u0002jg\u0002")
public class TraversableSerializerTestInstance<T>
extends ScalaSpecialTypesSerializerTestInstance<T> {
    @Test
    public void testAll() {
        super.testAll();
        this.testTraversableDeepCopy();
    }

    @Test
    public void testTraversableDeepCopy() {
        TypeSerializer serializer = this.getSerializer();
        TypeSerializer elementSerializer = ((TraversableSerializer)serializer).elementSerializer();
        Object[] data = this.getTestData();
        if (!elementSerializer.isImmutableType() && !(elementSerializer instanceof KryoSerializer)) {
            Predef$.MODULE$.refArrayOps(data).foreach((Function1)new Serializable(this, serializer){
                public static final long serialVersionUID = 0L;
                private final TypeSerializer serializer$1;

                public final void apply(T datum) {
                    Iterable original = ((Traversable)datum).toIterable();
                    Iterable copy = ((Traversable)this.serializer$1.copy(datum)).toIterable();
                    ((IterableLike)copy.zip((GenIterable)original, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final void apply(Tuple2<Object, Object> x0$1) {
                            Tuple2<Object, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                Object c = tuple2._1();
                                Object o = tuple2._2();
                                if (c instanceof Object) {
                                    Object object = c;
                                    if (o instanceof Object) {
                                        Object object2 = o;
                                        Assert.assertTrue((String)"Copy of mutable element has reference equality.", (object != object2 ? 1 : 0) != 0);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    });
                }
                {
                    this.serializer$1 = serializer$1;
                }
            });
        }
    }

    @Override
    @Test
    public void testInstantiate() {
        try {
            TypeSerializer serializer = this.getSerializer();
            Object instance = serializer.createInstance();
            Assert.assertNotNull((String)"The created instance must not be null.", (Object)instance);
            Class tpe = this.getTypeClass();
            Assert.assertNotNull((String)"The test is corrupt: type class is null.", (Object)tpe);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            Assert.fail((String)new StringBuilder().append((Object)"Exception in test: ").append((Object)exception.getMessage()).toString());
        }
    }

    @Override
    public void deepEquals(String message, T should, T is) {
        T t = should;
        if (t instanceof TraversableOnce) {
            T t2 = t;
            TraversableOnce isTrav = (TraversableOnce)is;
            Assert.assertEquals((String)message, (long)((TraversableOnce)t2).size(), (long)isTrav.size());
            Iterator it = ((GenTraversableOnce)t2).toIterator();
            Iterator isIt = isTrav.toIterator();
            while (it.hasNext()) {
                Object should2 = it.next();
                Object is2 = isIt.next();
                Assert.assertEquals((String)message, (Object)should2, (Object)is2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            super.deepEquals(message, should, is);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public TraversableSerializerTestInstance(TypeSerializer<T> serializer, Class<T> typeClass, int length, Object testData) {
        super(serializer, typeClass, length, testData);
    }
}

