/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.CheckpointingMode;

@Public
public class CheckpointConfig
implements Serializable {
    private static final long serialVersionUID = -750378776078908147L;
    public static final CheckpointingMode DEFAULT_MODE = CheckpointingMode.EXACTLY_ONCE;
    public static final long DEFAULT_TIMEOUT = 600000L;
    public static final long DEFAULT_MIN_PAUSE_BETWEEN_CHECKPOINTS = 0L;
    public static final int DEFAULT_MAX_CONCURRENT_CHECKPOINTS = 1;
    private CheckpointingMode checkpointingMode = DEFAULT_MODE;
    private long checkpointInterval = -1L;
    private long checkpointTimeout = 600000L;
    private long minPauseBetweenCheckpoints = 0L;
    private int maxConcurrentCheckpoints = 1;
    private boolean forceCheckpointing;

    public boolean isCheckpointingEnabled() {
        return this.checkpointInterval > 0L;
    }

    public CheckpointingMode getCheckpointingMode() {
        return this.checkpointingMode;
    }

    public void setCheckpointingMode(CheckpointingMode checkpointingMode) {
        this.checkpointingMode = Objects.requireNonNull(checkpointingMode);
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public void setCheckpointInterval(long checkpointInterval) {
        if (checkpointInterval <= 0L) {
            throw new IllegalArgumentException("Checkpoint interval must be larger than zero");
        }
        this.checkpointInterval = checkpointInterval;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    public void setCheckpointTimeout(long checkpointTimeout) {
        if (checkpointTimeout <= 0L) {
            throw new IllegalArgumentException("Checkpoint timeout must be larger than zero");
        }
        this.checkpointTimeout = checkpointTimeout;
    }

    public long getMinPauseBetweenCheckpoints() {
        return this.minPauseBetweenCheckpoints;
    }

    public int getMaxConcurrentCheckpoints() {
        return this.maxConcurrentCheckpoints;
    }

    public void setMaxConcurrentCheckpoints(int maxConcurrentCheckpoints) {
        if (maxConcurrentCheckpoints < 1) {
            throw new IllegalArgumentException("The maximum number of concurrent attempts must be at least one.");
        }
        this.maxConcurrentCheckpoints = maxConcurrentCheckpoints;
    }

    @Deprecated
    @PublicEvolving
    public boolean isForceCheckpointing() {
        return this.forceCheckpointing;
    }

    @Deprecated
    @PublicEvolving
    public void setForceCheckpointing(boolean forceCheckpointing) {
        this.forceCheckpointing = forceCheckpointing;
    }
}

