/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.SumFunction;
import org.apache.flink.streaming.util.FieldAccessor;

@Internal
public class SumAggregator<T>
extends AggregationFunction<T> {
    private static final long serialVersionUID = 1L;
    private final FieldAccessor<T, Object> fieldAccessor;
    private final SumFunction adder;
    private final TypeSerializer<T> serializer;
    private final boolean isTuple;

    public SumAggregator(int pos, TypeInformation<T> typeInfo, ExecutionConfig config) {
        this.fieldAccessor = FieldAccessor.create(pos, typeInfo, config);
        this.adder = SumFunction.getForClass(this.fieldAccessor.getFieldType().getTypeClass());
        if (typeInfo instanceof TupleTypeInfo) {
            this.isTuple = true;
            this.serializer = null;
        } else {
            this.isTuple = false;
            this.serializer = typeInfo.createSerializer(config);
        }
    }

    public SumAggregator(String field, TypeInformation<T> typeInfo, ExecutionConfig config) {
        this.fieldAccessor = FieldAccessor.create(field, typeInfo, config);
        this.adder = SumFunction.getForClass(this.fieldAccessor.getFieldType().getTypeClass());
        if (typeInfo instanceof TupleTypeInfo) {
            this.isTuple = true;
            this.serializer = null;
        } else {
            this.isTuple = false;
            this.serializer = typeInfo.createSerializer(config);
        }
    }

    public T reduce(T value1, T value2) throws Exception {
        if (this.isTuple) {
            Tuple result = ((Tuple)value1).copy();
            return (T)this.fieldAccessor.set(result, this.adder.add(this.fieldAccessor.get(value1), this.fieldAccessor.get(value2)));
        }
        Object result = this.serializer.copy(value1);
        return (T)this.fieldAccessor.set(result, this.adder.add(this.fieldAccessor.get(value1), this.fieldAccessor.get(value2)));
    }
}

