/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class StreamCounter<IN>
extends AbstractStreamOperator<Long>
implements OneInputStreamOperator<IN, Long> {
    private static final long serialVersionUID = 1L;
    private Long count = 0L;

    public StreamCounter() {
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    @Override
    public void processElement(StreamRecord<IN> element) {
        this.count = this.count + 1L;
        this.output.collect(element.replace(this.count));
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
        this.output.emitWatermark(mark);
    }
}

