/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class StreamSource<OUT, SRC extends SourceFunction<OUT>>
extends AbstractUdfStreamOperator<OUT, SRC>
implements StreamOperator<OUT> {
    private static final long serialVersionUID = 1L;
    private transient SourceFunction.SourceContext<OUT> ctx;
    private volatile transient boolean canceledOrStopped = false;

    public StreamSource(SRC sourceFunction) {
        super(sourceFunction);
        this.chainingStrategy = ChainingStrategy.HEAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Object lockingObject, Output<StreamRecord<OUT>> collector) throws Exception {
        SourceFunction.SourceContext ctx;
        TimeCharacteristic timeCharacteristic = this.getOperatorConfig().getTimeCharacteristic();
        switch (timeCharacteristic) {
            case EventTime: {
                ctx = new ManualWatermarkContext(this, lockingObject, collector);
                break;
            }
            case IngestionTime: {
                ctx = new AutomaticWatermarkContext(this, lockingObject, collector, this.getRuntimeContext().getExecutionConfig().getAutoWatermarkInterval());
                break;
            }
            case ProcessingTime: {
                ctx = new NonTimestampContext(this, lockingObject, collector);
                break;
            }
            default: {
                throw new Exception(String.valueOf((Object)timeCharacteristic));
            }
        }
        this.ctx = ctx;
        try {
            ((SourceFunction)this.userFunction).run(ctx);
            if (!this.isCanceledOrStopped()) {
                ctx.emitWatermark(Watermark.MAX_WATERMARK);
            }
        }
        finally {
            ctx.close();
        }
    }

    public void cancel() {
        this.markCanceledOrStopped();
        ((SourceFunction)this.userFunction).cancel();
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    protected void markCanceledOrStopped() {
        this.canceledOrStopped = true;
    }

    protected boolean isCanceledOrStopped() {
        return this.canceledOrStopped;
    }

    void checkAsyncException() {
        this.getContainingTask().checkTimerException();
    }

    public static class ManualWatermarkContext<T>
    implements SourceFunction.SourceContext<T> {
        private final StreamSource<?, ?> owner;
        private final Object lockingObject;
        private final Output<StreamRecord<T>> output;
        private final StreamRecord<T> reuse;

        public ManualWatermarkContext(StreamSource<?, ?> owner, Object lockingObject, Output<StreamRecord<T>> output) {
            this.owner = owner;
            this.lockingObject = lockingObject;
            this.output = output;
            this.reuse = new StreamRecord<Object>(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void collect(T element) {
            this.owner.checkAsyncException();
            Object object = this.lockingObject;
            synchronized (object) {
                this.output.collect(this.reuse.replace(element));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void collectWithTimestamp(T element, long timestamp) {
            this.owner.checkAsyncException();
            Object object = this.lockingObject;
            synchronized (object) {
                this.output.collect(this.reuse.replace(element, timestamp));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void emitWatermark(Watermark mark) {
            this.owner.checkAsyncException();
            Object object = this.lockingObject;
            synchronized (object) {
                this.output.emitWatermark(mark);
            }
        }

        @Override
        public Object getCheckpointLock() {
            return this.lockingObject;
        }

        @Override
        public void close() {
        }
    }

    public static class AutomaticWatermarkContext<T>
    implements SourceFunction.SourceContext<T> {
        private final StreamSource<?, ?> owner;
        private final Object lockingObject;
        private final Output<StreamRecord<T>> output;
        private final StreamRecord<T> reuse;
        private final ScheduledExecutorService scheduleExecutor;
        private final ScheduledFuture<?> watermarkTimer;
        private final long watermarkInterval;
        private volatile long nextWatermarkTime;

        public AutomaticWatermarkContext(StreamSource<?, ?> owner, final Object lockingObjectParam, final Output<StreamRecord<T>> outputParam, final long watermarkInterval) {
            if (watermarkInterval < 1L) {
                throw new IllegalArgumentException("The watermark interval cannot be smaller than one.");
            }
            this.owner = owner;
            this.lockingObject = lockingObjectParam;
            this.output = outputParam;
            this.watermarkInterval = watermarkInterval;
            this.reuse = new StreamRecord<Object>(null);
            this.scheduleExecutor = Executors.newScheduledThreadPool(1);
            this.watermarkTimer = this.scheduleExecutor.scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime > AutomaticWatermarkContext.this.nextWatermarkTime) {
                        long watermarkTime = currentTime - currentTime % watermarkInterval;
                        Object object = lockingObjectParam;
                        synchronized (object) {
                            if (currentTime > AutomaticWatermarkContext.this.nextWatermarkTime) {
                                outputParam.emitWatermark(new Watermark(watermarkTime));
                                AutomaticWatermarkContext.this.nextWatermarkTime = AutomaticWatermarkContext.this.nextWatermarkTime + watermarkInterval;
                            }
                        }
                    }
                }
            }, 0L, watermarkInterval, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void collect(T element) {
            this.owner.checkAsyncException();
            Object object = this.lockingObject;
            synchronized (object) {
                long currentTime = System.currentTimeMillis();
                this.output.collect(this.reuse.replace(element, currentTime));
                if (currentTime > this.nextWatermarkTime) {
                    long watermarkTime = currentTime - currentTime % this.watermarkInterval;
                    this.nextWatermarkTime = watermarkTime + this.watermarkInterval;
                    this.output.emitWatermark(new Watermark(watermarkTime));
                }
            }
        }

        @Override
        public void collectWithTimestamp(T element, long timestamp) {
            this.collect(element);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void emitWatermark(Watermark mark) {
            this.owner.checkAsyncException();
            if (mark.getTimestamp() == Long.MAX_VALUE) {
                Object object = this.lockingObject;
                synchronized (object) {
                    this.nextWatermarkTime = Long.MAX_VALUE;
                    this.output.emitWatermark(mark);
                }
                this.watermarkTimer.cancel(true);
                this.scheduleExecutor.shutdownNow();
            }
        }

        @Override
        public Object getCheckpointLock() {
            return this.lockingObject;
        }

        @Override
        public void close() {
            this.watermarkTimer.cancel(true);
            this.scheduleExecutor.shutdownNow();
        }
    }

    public static class NonTimestampContext<T>
    implements SourceFunction.SourceContext<T> {
        private final StreamSource<?, ?> owner;
        private final Object lockingObject;
        private final Output<StreamRecord<T>> output;
        private final StreamRecord<T> reuse;

        public NonTimestampContext(StreamSource<?, ?> owner, Object lockingObject, Output<StreamRecord<T>> output) {
            this.owner = owner;
            this.lockingObject = lockingObject;
            this.output = output;
            this.reuse = new StreamRecord<Object>(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void collect(T element) {
            this.owner.checkAsyncException();
            Object object = this.lockingObject;
            synchronized (object) {
                this.output.collect(this.reuse.replace(element));
            }
        }

        @Override
        public void collectWithTimestamp(T element, long timestamp) {
            this.collect(element);
        }

        @Override
        public void emitWatermark(Watermark mark) {
            this.owner.checkAsyncException();
        }

        @Override
        public Object getCheckpointLock() {
            return this.lockingObject;
        }

        @Override
        public void close() {
        }
    }
}

