/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.functions.util.AbstractRuntimeUDFContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.OperatorState;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.runtime.operators.Triggerable;

@PublicEvolving
public class StreamingRuntimeContext
extends AbstractRuntimeUDFContext {
    private final AbstractStreamOperator<?> operator;
    private final Environment taskEnvironment;
    private final StreamConfig streamConfig;

    public StreamingRuntimeContext(AbstractStreamOperator<?> operator, Environment env, Map<String, Accumulator<?, ?>> accumulators) {
        super(env.getTaskInfo(), env.getUserClassLoader(), operator.getExecutionConfig(), accumulators, env.getDistributedCacheEntries());
        this.operator = operator;
        this.taskEnvironment = env;
        this.streamConfig = new StreamConfig(env.getTaskConfiguration());
    }

    public InputSplitProvider getInputSplitProvider() {
        return this.taskEnvironment.getInputSplitProvider();
    }

    public void registerTimer(long time, Triggerable target) {
        this.operator.registerTimer(time, target);
    }

    public <RT> List<RT> getBroadcastVariable(String name) {
        throw new UnsupportedOperationException("Broadcast variables can only be used in DataSet programs");
    }

    public <T, C> C getBroadcastVariableWithInitializer(String name, BroadcastVariableInitializer<T, C> initializer) {
        throw new UnsupportedOperationException("Broadcast variables can only be used in DataSet programs");
    }

    public <T> ValueState<T> getState(ValueStateDescriptor<T> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.getExecutionConfig());
            return (ValueState)this.operator.getPartitionedState(stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    public <T> ListState<T> getListState(ListStateDescriptor<T> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.getExecutionConfig());
            return (ListState)this.operator.getPartitionedState(stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    public <T> ReducingState<T> getReducingState(ReducingStateDescriptor<T> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.getExecutionConfig());
            return (ReducingState)this.operator.getPartitionedState(stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    @Deprecated
    public <S> OperatorState<S> getKeyValueState(String name, Class<S> stateType, S defaultState) {
        TypeInformation typeInfo;
        Objects.requireNonNull(stateType, "The state type class must not be null");
        try {
            typeInfo = TypeExtractor.getForClass(stateType);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot analyze type '" + stateType.getName() + "' from the class alone, due to generic type parameters. " + "Please specify the TypeInformation directly.", e);
        }
        return this.getKeyValueState(name, typeInfo, defaultState);
    }

    @Deprecated
    public <S> OperatorState<S> getKeyValueState(String name, TypeInformation<S> stateType, S defaultState) {
        Objects.requireNonNull(name, "The name of the state must not be null");
        Objects.requireNonNull(stateType, "The state type information must not be null");
        ValueStateDescriptor stateProps = new ValueStateDescriptor(name, stateType, defaultState);
        return this.getState(stateProps);
    }

    public boolean isCheckpointingEnabled() {
        return this.streamConfig.isCheckpointingEnabled();
    }

    public CheckpointingMode getCheckpointMode() {
        return this.streamConfig.getCheckpointMode();
    }

    public long getBufferTimeout() {
        return this.streamConfig.getBufferTimeout();
    }
}

