/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.evictors;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@PublicEvolving
public class CountEvictor<W extends Window>
implements Evictor<Object, W> {
    private static final long serialVersionUID = 1L;
    private final long maxCount;

    private CountEvictor(long count) {
        this.maxCount = count;
    }

    @Override
    public int evict(Iterable<StreamRecord<Object>> elements, int size, W window) {
        if ((long)size > this.maxCount) {
            return (int)((long)size - this.maxCount);
        }
        return 0;
    }

    public static <W extends Window> CountEvictor<W> of(long maxCount) {
        return new CountEvictor<W>(maxCount);
    }
}

