/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.evictors;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.com.google.common.collect.Iterables;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@PublicEvolving
public class TimeEvictor<W extends Window>
implements Evictor<Object, W> {
    private static final long serialVersionUID = 1L;
    private final long windowSize;

    public TimeEvictor(long windowSize) {
        this.windowSize = windowSize;
    }

    @Override
    public int evict(Iterable<StreamRecord<Object>> elements, int size, W window) {
        int toEvict = 0;
        long currentTime = Iterables.getLast(elements).getTimestamp();
        long evictCutoff = currentTime - this.windowSize;
        for (StreamRecord<Object> record : elements) {
            if (record.getTimestamp() > evictCutoff) break;
            ++toEvict;
        }
        return toEvict;
    }

    public String toString() {
        return "TimeEvictor(" + this.windowSize + ")";
    }

    @VisibleForTesting
    public long getWindowSize() {
        return this.windowSize;
    }

    public static <W extends Window> TimeEvictor<W> of(Time windowSize) {
        return new TimeEvictor<W>(windowSize.toMilliseconds());
    }
}

