/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.time;

import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Public;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

@Public
public final class Time {
    private final TimeUnit unit;
    private final long size;

    private Time(long size, TimeUnit unit) {
        this.unit = Preconditions.checkNotNull(unit, "time unit may not be null");
        this.size = size;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long getSize() {
        return this.size;
    }

    public long toMilliseconds() {
        return this.unit.toMillis(this.size);
    }

    public static Time of(long size, TimeUnit unit) {
        return new Time(size, unit);
    }

    public static Time milliseconds(long milliseconds) {
        return Time.of(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static Time seconds(long seconds) {
        return Time.of(seconds, TimeUnit.SECONDS);
    }

    public static Time minutes(long minutes) {
        return Time.of(minutes, TimeUnit.MINUTES);
    }

    public static Time hours(long hours) {
        return Time.of(hours, TimeUnit.HOURS);
    }

    public static Time days(long days) {
        return Time.of(days, TimeUnit.DAYS);
    }
}

