/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.StreamRecordWriter;
import org.apache.flink.streaming.runtime.streamrecord.MultiplexingStreamRecordSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecordSerializer;

@Internal
public class RecordWriterOutput<OUT>
implements Output<StreamRecord<OUT>> {
    private StreamRecordWriter<SerializationDelegate<StreamElement>> recordWriter;
    private SerializationDelegate<StreamElement> serializationDelegate;

    public RecordWriterOutput(StreamRecordWriter<SerializationDelegate<StreamRecord<OUT>>> recordWriter, TypeSerializer<OUT> outSerializer, boolean enableWatermarkMultiplexing) {
        Preconditions.checkNotNull(recordWriter);
        this.recordWriter = recordWriter;
        TypeSerializer outRecordSerializer = enableWatermarkMultiplexing ? new MultiplexingStreamRecordSerializer<OUT>(outSerializer) : new StreamRecordSerializer<OUT>(outSerializer);
        if (outSerializer != null) {
            this.serializationDelegate = new SerializationDelegate(outRecordSerializer);
        }
    }

    public void collect(StreamRecord<OUT> record) {
        this.serializationDelegate.setInstance(record);
        try {
            this.recordWriter.emit(this.serializationDelegate);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void emitWatermark(Watermark mark) {
        this.serializationDelegate.setInstance((Object)mark);
        try {
            this.recordWriter.broadcastEmit(this.serializationDelegate);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void broadcastEvent(AbstractEvent barrier) throws IOException, InterruptedException {
        this.recordWriter.broadcastEvent(barrier);
    }

    public void flush() throws IOException {
        this.recordWriter.flush();
    }

    public void close() {
        this.recordWriter.close();
    }

    public void clearBuffers() {
        this.recordWriter.clearBuffers();
    }
}

