/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing.buffers;

import java.io.IOException;
import java.util.ArrayDeque;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.shaded.com.google.common.base.Function;
import org.apache.flink.shaded.com.google.common.collect.FluentIterable;
import org.apache.flink.streaming.runtime.operators.windowing.buffers.EvictingWindowBuffer;
import org.apache.flink.streaming.runtime.operators.windowing.buffers.WindowBufferFactory;
import org.apache.flink.streaming.runtime.streamrecord.MultiplexingStreamRecordSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class ListWindowBuffer<T>
implements EvictingWindowBuffer<T, T> {
    private final TypeSerializer<T> serializer;
    private ArrayDeque<StreamRecord<T>> elements;

    protected ListWindowBuffer(TypeSerializer<T> serializer) {
        this.serializer = serializer;
        this.elements = new ArrayDeque();
    }

    protected ListWindowBuffer(ArrayDeque<StreamRecord<T>> elements, TypeSerializer<T> serializer) {
        this.serializer = serializer;
        this.elements = elements;
    }

    @Override
    public void storeElement(StreamRecord<T> element) {
        this.elements.add(element);
    }

    @Override
    public void removeElements(int count) {
        for (int i = 0; i < count; ++i) {
            this.elements.removeFirst();
        }
    }

    @Override
    public Iterable<StreamRecord<T>> getElements() {
        return this.elements;
    }

    @Override
    public Iterable<T> getUnpackedElements() {
        return FluentIterable.from(this.elements).transform(new Function<StreamRecord<T>, T>(){

            @Override
            public T apply(StreamRecord<T> record) {
                return record.getValue();
            }
        });
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public void snapshot(DataOutputView out) throws IOException {
        out.writeInt(this.elements.size());
        MultiplexingStreamRecordSerializer<T> recordSerializer = new MultiplexingStreamRecordSerializer<T>(this.serializer);
        for (StreamRecord<T> e : this.elements) {
            recordSerializer.serialize(e, out);
        }
    }

    public static class Factory<T>
    implements WindowBufferFactory<T, T, ListWindowBuffer<T>> {
        private static final long serialVersionUID = 1L;
        private final TypeSerializer<T> serializer;

        public Factory(TypeSerializer<T> serializer) {
            this.serializer = serializer;
        }

        @Override
        public ListWindowBuffer<T> create() {
            return new ListWindowBuffer<T>(this.serializer);
        }

        @Override
        public ListWindowBuffer<T> restoreFromSnapshot(DataInputView in) throws IOException {
            int size = in.readInt();
            MultiplexingStreamRecordSerializer<T> recordSerializer = new MultiplexingStreamRecordSerializer<T>(this.serializer);
            ArrayDeque elements = new ArrayDeque();
            for (int i = 0; i < size; ++i) {
                elements.add(recordSerializer.deserialize(in).asRecord());
            }
            return new ListWindowBuffer(elements, this.serializer);
        }
    }
}

