/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing.functions;

import java.util.Collections;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalWindowFunction;
import org.apache.flink.util.Collector;

public final class InternalSingleValueWindowFunction<IN, OUT, KEY, W extends Window>
extends InternalWindowFunction<IN, OUT, KEY, W>
implements RichFunction {
    private static final long serialVersionUID = 1L;
    protected WindowFunction<IN, OUT, KEY, W> wrappedFunction;

    public InternalSingleValueWindowFunction(WindowFunction<IN, OUT, KEY, W> wrappedFunction) {
        this.wrappedFunction = wrappedFunction;
    }

    @Override
    public void apply(KEY key, W window, IN input, Collector<OUT> out) throws Exception {
        this.wrappedFunction.apply(key, window, Collections.singletonList(input), out);
    }

    public void open(Configuration parameters) throws Exception {
        FunctionUtils.openFunction(this.wrappedFunction, (Configuration)parameters);
    }

    public void close() throws Exception {
        FunctionUtils.closeFunction(this.wrappedFunction);
    }

    public void setRuntimeContext(RuntimeContext t) {
        FunctionUtils.setFunctionRuntimeContext(this.wrappedFunction, (RuntimeContext)t);
    }

    public RuntimeContext getRuntimeContext() {
        throw new RuntimeException("This should never be called.");
    }

    public IterationRuntimeContext getIterationRuntimeContext() {
        throw new RuntimeException("This should never be called.");
    }
}

