/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.collector.selector;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.collector.selector.DirectedOutput;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class CopyingDirectedOutput<OUT>
extends DirectedOutput<OUT> {
    public CopyingDirectedOutput(List<OutputSelector<OUT>> outputSelectors, List<Tuple2<Output<StreamRecord<OUT>>, StreamEdge>> outputs) {
        super(outputSelectors, outputs);
    }

    @Override
    public void collect(StreamRecord<OUT> record) {
        Output<StreamRecord<OUT>> out;
        Set<Output<StreamRecord<OUT>>> selectedOutputs = this.selectOutputs(record);
        if (selectedOutputs.isEmpty()) {
            return;
        }
        Iterator<Output<StreamRecord<OUT>>> it = selectedOutputs.iterator();
        while (true) {
            out = it.next();
            if (!it.hasNext()) break;
            StreamRecord<OUT> shallowCopy = record.copy(record.getValue());
            out.collect(shallowCopy);
        }
        out.collect(record);
    }
}

