/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class QueryableStateStream<K, V> {
    private final String queryableStateName;
    private final TypeSerializer<K> keySerializer;
    private final TypeSerializer<V> valueSerializer;

    public QueryableStateStream(String queryableStateName, TypeSerializer<V> valueSerializer, TypeSerializer<K> keySerializer) {
        this.queryableStateName = (String)Preconditions.checkNotNull((Object)queryableStateName, (String)"Queryable state name");
        this.valueSerializer = (TypeSerializer)Preconditions.checkNotNull(valueSerializer, (String)"Value serializer");
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull(keySerializer, (String)"Key serializer");
    }

    public String getQueryableStateName() {
        return this.queryableStateName;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }
}

