/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class Flip6LocalStreamEnvironment
extends StreamExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(Flip6LocalStreamEnvironment.class);
    private final Configuration conf;

    public Flip6LocalStreamEnvironment() {
        this(null);
    }

    public Flip6LocalStreamEnvironment(Configuration config) {
        if (!ExecutionEnvironment.areExplicitEnvironmentsAllowed()) {
            throw new InvalidProgramException("The Flip6LocalStreamEnvironment cannot be used when submitting a program through a client, or running in a TestEnvironment context.");
        }
        this.conf = config == null ? new Configuration() : config;
        this.setParallelism(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        StreamGraph streamGraph = this.getStreamGraph();
        streamGraph.setJobName(jobName);
        streamGraph.getExecutionConfig().setRestartStrategy(RestartStrategies.fixedDelayRestart((int)Integer.MAX_VALUE, (long)5L));
        JobGraph jobGraph = streamGraph.getJobGraph();
        jobGraph.setAllowQueuedScheduling(true);
        Configuration configuration = new Configuration();
        configuration.addAll(jobGraph.getJobConfiguration());
        configuration.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, -1L);
        configuration.addAll(this.conf);
        MiniClusterConfiguration cfg = new MiniClusterConfiguration(configuration);
        int slotsCount = 0;
        for (JobVertex jobVertex : jobGraph.getVertices()) {
            slotsCount += jobVertex.getParallelism();
        }
        cfg.setNumTaskManagerSlots(slotsCount);
        if (LOG.isInfoEnabled()) {
            LOG.info("Running job on local embedded Flink mini cluster");
        }
        MiniCluster miniCluster = new MiniCluster(cfg);
        try {
            miniCluster.start();
            miniCluster.waitUntilTaskManagerRegistrationsComplete();
            JobExecutionResult jobExecutionResult = miniCluster.runJobBlocking(jobGraph);
            return jobExecutionResult;
        }
        finally {
            this.transformations.clear();
            miniCluster.shutdown();
        }
    }
}

