/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.streaming.runtime.io.BufferBlocker;
import org.apache.flink.streaming.runtime.io.BufferOrEventSequence;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.StringUtils;

@Deprecated
@Internal
public class BufferSpiller
implements BufferBlocker {
    static final int HEADER_SIZE = 9;
    private static final AtomicInteger DIRECTORY_INDEX = new AtomicInteger(0);
    private static final int READ_BUFFER_SIZE = 0x100000;
    private final File tempDir;
    private final String spillFilePrefix;
    private final ByteBuffer readBuffer;
    private final ByteBuffer headBuffer;
    private File currentSpillFile;
    private FileChannel currentChannel;
    private final int pageSize;
    private int fileCounter;
    private long bytesWritten;

    public BufferSpiller(IOManager ioManager, int pageSize) throws IOException {
        this.pageSize = pageSize;
        this.readBuffer = ByteBuffer.allocateDirect(0x100000);
        this.readBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.headBuffer = ByteBuffer.allocateDirect(16);
        this.headBuffer.order(ByteOrder.LITTLE_ENDIAN);
        File[] tempDirs = ioManager.getSpillingDirectories();
        this.tempDir = tempDirs[DIRECTORY_INDEX.getAndIncrement() % tempDirs.length];
        byte[] rndBytes = new byte[32];
        ThreadLocalRandom.current().nextBytes(rndBytes);
        this.spillFilePrefix = StringUtils.byteToHexString((byte[])rndBytes) + '.';
        this.createSpillingChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(BufferOrEvent boe) throws IOException {
        try {
            ByteBuffer contents;
            if (boe.isBuffer()) {
                Buffer buf = boe.getBuffer();
                contents = buf.getNioBufferReadable();
            } else {
                contents = EventSerializer.toSerializedEvent((AbstractEvent)boe.getEvent());
            }
            this.headBuffer.clear();
            this.headBuffer.putInt(boe.getChannelIndex());
            this.headBuffer.putInt(contents.remaining());
            this.headBuffer.put((byte)(!boe.isBuffer() ? 1 : 0));
            this.headBuffer.flip();
            this.bytesWritten += (long)(this.headBuffer.remaining() + contents.remaining());
            FileUtils.writeCompletely((WritableByteChannel)this.currentChannel, (ByteBuffer)this.headBuffer);
            FileUtils.writeCompletely((WritableByteChannel)this.currentChannel, (ByteBuffer)contents);
        }
        finally {
            if (boe.isBuffer()) {
                boe.getBuffer().recycleBuffer();
            }
        }
    }

    @Override
    public BufferOrEventSequence rollOverReusingResources() throws IOException {
        return this.rollOver(false);
    }

    @Override
    public BufferOrEventSequence rollOverWithoutReusingResources() throws IOException {
        return this.rollOver(true);
    }

    private BufferOrEventSequence rollOver(boolean newBuffer) throws IOException {
        ByteBuffer buf;
        if (this.bytesWritten == 0L) {
            return null;
        }
        if (newBuffer) {
            buf = ByteBuffer.allocateDirect(0x100000);
            buf.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            buf = this.readBuffer;
        }
        this.currentChannel.position(0L);
        SpilledBufferOrEventSequence seq = new SpilledBufferOrEventSequence(this.currentSpillFile, this.currentChannel, buf, this.pageSize);
        this.createSpillingChannel();
        this.bytesWritten = 0L;
        return seq;
    }

    @Override
    public void close() throws IOException {
        this.currentChannel.close();
        if (!this.currentSpillFile.delete()) {
            throw new IOException("Cannot delete spill file");
        }
    }

    @Override
    public long getBytesBlocked() {
        return this.bytesWritten;
    }

    File getCurrentSpillFile() {
        return this.currentSpillFile;
    }

    FileChannel getCurrentChannel() {
        return this.currentChannel;
    }

    private void createSpillingChannel() throws IOException {
        this.currentSpillFile = new File(this.tempDir, this.spillFilePrefix + this.fileCounter++ + ".buffer");
        this.currentChannel = new RandomAccessFile(this.currentSpillFile, "rw").getChannel();
    }

    @Deprecated
    public static class SpilledBufferOrEventSequence
    implements BufferOrEventSequence {
        private static final int HEADER_LENGTH = 9;
        private final File file;
        private final FileChannel fileChannel;
        private final ByteBuffer buffer;
        private final long size;
        private final int pageSize;
        private boolean opened = false;

        SpilledBufferOrEventSequence(File file, FileChannel fileChannel, ByteBuffer buffer, int pageSize) throws IOException {
            this.file = file;
            this.fileChannel = fileChannel;
            this.buffer = buffer;
            this.pageSize = pageSize;
            this.size = fileChannel.size();
        }

        @Override
        public void open() {
            if (!this.opened) {
                this.opened = true;
                this.buffer.position(0);
                this.buffer.limit(0);
            }
        }

        @Override
        public BufferOrEvent getNext() throws IOException {
            boolean isBuffer;
            if (this.buffer.remaining() < 9) {
                this.buffer.compact();
                while (this.buffer.position() < 9) {
                    if (this.fileChannel.read(this.buffer) != -1) continue;
                    if (this.buffer.position() == 0) {
                        return null;
                    }
                    throw new IOException("Found trailing incomplete buffer or event");
                }
                this.buffer.flip();
            }
            int channel = this.buffer.getInt();
            int length = this.buffer.getInt();
            boolean bl = isBuffer = this.buffer.get() == 0;
            if (isBuffer) {
                if (length > this.pageSize) {
                    throw new IOException(String.format("Spilled buffer (%d bytes) is larger than page size of (%d bytes)", length, this.pageSize));
                }
                MemorySegment seg = MemorySegmentFactory.allocateUnpooledSegment((int)this.pageSize);
                int segPos = 0;
                int bytesRemaining = length;
                while (true) {
                    int toCopy;
                    if ((toCopy = Math.min(this.buffer.remaining(), bytesRemaining)) > 0) {
                        seg.put(segPos, this.buffer, toCopy);
                        segPos += toCopy;
                        bytesRemaining -= toCopy;
                    }
                    if (bytesRemaining == 0) break;
                    this.buffer.clear();
                    if (this.fileChannel.read(this.buffer) == -1) {
                        throw new IOException("Found trailing incomplete buffer");
                    }
                    this.buffer.flip();
                }
                NetworkBuffer buf = new NetworkBuffer(seg, FreeingBufferRecycler.INSTANCE);
                buf.setSize(length);
                return new BufferOrEvent((Buffer)buf, channel);
            }
            if (length > this.buffer.capacity() - 9) {
                throw new IOException("Event is too large");
            }
            if (this.buffer.remaining() < length) {
                this.buffer.compact();
                while (this.buffer.position() < length) {
                    if (this.fileChannel.read(this.buffer) != -1) continue;
                    throw new IOException("Found trailing incomplete event");
                }
                this.buffer.flip();
            }
            int oldLimit = this.buffer.limit();
            this.buffer.limit(this.buffer.position() + length);
            AbstractEvent evt = EventSerializer.fromSerializedEvent((ByteBuffer)this.buffer, (ClassLoader)this.getClass().getClassLoader());
            this.buffer.limit(oldLimit);
            return new BufferOrEvent(evt, channel);
        }

        @Override
        public void cleanup() throws IOException {
            this.fileChannel.close();
            if (!this.file.delete()) {
                throw new IOException("Cannot remove temp file for stream alignment writer");
            }
        }

        @Override
        public long size() {
            return this.size;
        }
    }
}

