/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.streaming.runtime.tasks.CheckpointExceptionHandler;
import org.apache.flink.util.Preconditions;

public class CheckpointExceptionHandlerFactory {
    public CheckpointExceptionHandler createCheckpointExceptionHandler(boolean failTaskOnCheckpointException, Environment environment) {
        if (failTaskOnCheckpointException) {
            return new FailingCheckpointExceptionHandler();
        }
        return new DecliningCheckpointExceptionHandler(environment);
    }

    static final class DecliningCheckpointExceptionHandler
    implements CheckpointExceptionHandler {
        final Environment environment;

        DecliningCheckpointExceptionHandler(Environment environment) {
            this.environment = (Environment)Preconditions.checkNotNull((Object)environment);
        }

        @Override
        public void tryHandleCheckpointException(CheckpointMetaData checkpointMetaData, Exception exception) throws Exception {
            this.environment.declineCheckpoint(checkpointMetaData.getCheckpointId(), (Throwable)exception);
        }
    }

    static final class FailingCheckpointExceptionHandler
    implements CheckpointExceptionHandler {
        FailingCheckpointExceptionHandler() {
        }

        @Override
        public void tryHandleCheckpointException(CheckpointMetaData checkpointMetaData, Exception exception) throws Exception {
            throw exception;
        }
    }
}

