/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.plugin.car;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.geronimo.plugin.MojoSupport;
import org.apache.geronimo.plugin.car.ArtifactItem;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public abstract class AbstractCarMojo
extends MojoSupport {
    protected MavenProject project;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    protected ArtifactRepository local;
    protected List remoteRepos;
    protected File basedir;
    protected MavenProjectHelper projectHelper;
    protected ArtifactFactory artifactFactory;

    protected Set getProjectArtifacts(MavenProject project) {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        Iterator dependencies = project.getDependencies().iterator();
        while (dependencies.hasNext()) {
            Dependency dep = (Dependency)dependencies.next();
            String groupId = dep.getGroupId();
            String artifactId = dep.getArtifactId();
            VersionRange versionRange = VersionRange.createFromVersion((String)dep.getVersion());
            String type = dep.getType();
            if (type == null) {
                type = "jar";
            }
            String classifier = dep.getClassifier();
            boolean optional = dep.isOptional();
            String scope = dep.getScope();
            if (scope == null) {
                scope = "compile";
            }
            Artifact artifact = this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, optional);
            if (scope.equalsIgnoreCase("system")) {
                artifact.setFile(new File(dep.getSystemPath()));
            }
            ArrayList<String> exclusions = new ArrayList<String>();
            Iterator j = dep.getExclusions().iterator();
            while (j.hasNext()) {
                Exclusion e = (Exclusion)j.next();
                exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
            }
            ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
            artifact.setDependencyFilter((ArtifactFilter)newFilter);
            artifacts.add(artifact);
        }
        return artifacts;
    }

    protected Set getProjectArtifacts() {
        return this.getProjectArtifacts(this.project);
    }

    protected void generateExplicitVersionProperties(File outputFile) throws IOException {
        this.log.debug((CharSequence)("Generating explicit version properties: " + outputFile));
        Properties props = new Properties();
        Iterator iter = this.getProjectArtifacts().iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            String name = artifact.getGroupId() + "/" + artifact.getArtifactId() + "//" + artifact.getType();
            String value = artifact.getVersion();
            this.log.debug((CharSequence)("Setting " + name + "=" + value));
            props.setProperty(name, value);
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile));
        props.store(output, null);
        output.flush();
        output.close();
    }

    protected static File getArchiveFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".car");
    }

    protected Artifact getArtifact(ArtifactItem item) throws MojoExecutionException {
        String classifier;
        if (item.getVersion() == null) {
            this.fillMissingArtifactVersion(item);
            if (item.getVersion() == null) {
                throw new MojoExecutionException("Unable to find artifact version of " + item.getGroupId() + ":" + item.getArtifactId() + " in either dependency list or in project's dependency management.");
            }
        }
        Artifact artifact = (classifier = item.getClassifier()) == null || classifier.equals("") ? this.factory.createArtifact(item.getGroupId(), item.getArtifactId(), item.getVersion(), "provided", item.getType()) : this.factory.createArtifactWithClassifier(item.getGroupId(), item.getArtifactId(), item.getVersion(), item.getType(), item.getClassifier());
        try {
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
        return artifact;
    }

    private void fillMissingArtifactVersion(ArtifactItem item) {
        Dependency dependency;
        int i;
        this.log.debug((CharSequence)("Attempting to find missing version in " + item.getGroupId() + ":" + item.getArtifactId()));
        List list = this.project.getDependencies();
        for (i = 0; i < list.size(); ++i) {
            dependency = (Dependency)list.get(i);
            if (!dependency.getGroupId().equals(item.getGroupId()) || !dependency.getArtifactId().equals(item.getArtifactId()) || !dependency.getType().equals(item.getType())) continue;
            this.log.debug((CharSequence)("Found missing version: " + dependency.getVersion() + " in dependency list."));
            item.setVersion(dependency.getVersion());
            return;
        }
        list = this.project.getDependencyManagement().getDependencies();
        for (i = 0; i < list.size(); ++i) {
            dependency = (Dependency)list.get(i);
            if (!dependency.getGroupId().equals(item.getGroupId()) || !dependency.getArtifactId().equals(item.getArtifactId()) || !dependency.getType().equals(item.getType())) continue;
            this.log.debug((CharSequence)("Found missing version: " + dependency.getVersion() + " in dependency management list"));
            item.setVersion(dependency.getVersion());
        }
    }
}

