/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.plugin.car;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.DefaultArtifactManager;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.WritableListableRepository;
import org.apache.geronimo.plugin.car.AbstractCarMojo;
import org.apache.geronimo.system.configuration.RepositoryConfigurationStore;
import org.apache.geronimo.system.repository.Maven2Repository;
import org.apache.geronimo.system.resolver.ExplicitDefaultArtifactResolver;
import org.apache.maven.artifact.repository.ArtifactRepository;

public class InstallConfigMojo
extends AbstractCarMojo {
    public static final FileWriteMonitor LOG_COPY_START = new StartFileWriteMonitor();
    private String targetRoot;
    private String targetRepository;
    private String artifact;
    private ArtifactRepository sourceRepository;
    private File explicitResolutionProperties;
    private ArtifactResolver artifactResolver;
    private WritableListableRepository targetRepo;
    private RepositoryConfigurationStore targetStore;
    private WritableListableRepository sourceRepo;
    private RepositoryConfigurationStore sourceStore;

    protected void doExecute() throws Exception {
        this.generateExplicitVersionProperties(this.explicitResolutionProperties);
        this.sourceRepo = new Maven2Repository(new File(this.sourceRepository.getBasedir()));
        this.sourceStore = new RepositoryConfigurationStore(this.sourceRepo);
        File targetRepoFile = new File(this.targetRoot, this.targetRepository);
        if (!targetRepoFile.exists()) {
            targetRepoFile.mkdirs();
        }
        this.targetRepo = new Maven2Repository(targetRepoFile);
        this.targetStore = new RepositoryConfigurationStore(this.targetRepo);
        DefaultArtifactManager artifactManager = new DefaultArtifactManager();
        this.artifactResolver = new ExplicitDefaultArtifactResolver(this.explicitResolutionProperties.getPath(), (ArtifactManager)artifactManager, Collections.singleton(this.sourceRepo), null);
        if (this.artifact != null) {
            Artifact configId = Artifact.create((String)this.artifact);
            this.execute(configId);
        } else {
            Iterator itr = this.getDependencies().iterator();
            while (itr.hasNext()) {
                org.apache.maven.artifact.Artifact mavenArtifact = (org.apache.maven.artifact.Artifact)itr.next();
                if (!"car".equals(mavenArtifact.getType())) continue;
                Artifact configId = new Artifact(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion(), "car");
                this.execute(configId);
            }
        }
    }

    protected Set getDependencies() {
        Set projectArtifacts;
        HashSet<org.apache.maven.artifact.Artifact> dependenciesSet = new HashSet<org.apache.maven.artifact.Artifact>();
        if (this.project.getArtifact() != null && this.project.getArtifact().getFile() != null) {
            dependenciesSet.add(this.project.getArtifact());
        }
        if ((projectArtifacts = this.project.getArtifacts()) != null) {
            dependenciesSet.addAll(projectArtifacts);
        }
        return dependenciesSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Artifact configId) throws Exception {
        LinkedHashSet dependencies;
        FileInputStream in;
        File sourceFile;
        if (!this.sourceRepo.contains(configId)) {
            throw new NoSuchConfigException(configId);
        }
        if (this.targetStore.containsConfiguration(configId)) {
            this.log.info((CharSequence)("Configuration " + configId + " already present in configuration store"));
            return;
        }
        if (this.sourceStore.containsConfiguration(configId)) {
            if (!this.targetStore.containsConfiguration(configId)) {
                sourceFile = this.sourceRepo.getLocation(configId);
                in = new FileInputStream(sourceFile);
                try {
                    this.targetStore.install((InputStream)in, (int)sourceFile.length(), configId, LOG_COPY_START);
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            try {
                ConfigurationData configurationData = this.targetStore.loadConfiguration(configId);
                Environment environment = configurationData.getEnvironment();
                dependencies = new LinkedHashSet();
                Iterator iterator = environment.getDependencies().iterator();
                while (iterator.hasNext()) {
                    Dependency dependency = (Dependency)iterator.next();
                    dependencies.add(dependency.getArtifact());
                }
                this.log.info((CharSequence)("Installed configuration " + configId));
            }
            catch (IOException e) {
                throw new InvalidConfigException("Unable to load configuration: " + configId, (Throwable)e);
            }
            catch (NoSuchConfigException e) {
                throw new InvalidConfigException("Unable to load configuration: " + configId, (Throwable)e);
            }
        }
        if (!this.sourceRepo.contains(configId)) {
            throw new RuntimeException("Dependency: " + configId + " not found in local maven repo: for configuration: " + this.artifact);
        }
        if (!this.targetRepo.contains(configId)) {
            sourceFile = this.sourceRepo.getLocation(configId);
            in = new FileInputStream(sourceFile);
            try {
                this.targetRepo.copyToRepository((InputStream)in, (int)sourceFile.length(), configId, LOG_COPY_START);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        dependencies = this.sourceRepo.getDependencies(configId);
        dependencies = this.artifactResolver.resolveInClassLoader(dependencies);
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            this.execute(artifact);
        }
    }

    private static class StartFileWriteMonitor
    implements FileWriteMonitor {
        private StartFileWriteMonitor() {
        }

        public void writeStarted(String fileDescription, int fileSize) {
            System.out.println("Copying " + fileDescription);
        }

        public void writeProgress(int bytes) {
        }

        public void writeComplete(int bytes) {
        }
    }
}

