/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.plugin.car;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelFactory;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.KernelConfigurationManager;
import org.apache.geronimo.kernel.log.GeronimoLogging;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.DefaultArtifactManager;
import org.apache.geronimo.plugin.car.MavenAttributeStore;
import org.apache.geronimo.system.resolver.ExplicitDefaultArtifactResolver;

public class PackageBuilder {
    private static final String KERNEL_NAME = "geronimo.maven";
    private static final String[] ARG_TYPES = new String[]{Boolean.TYPE.getName(), File.class.getName(), File.class.getName(), File.class.getName(), Boolean.TYPE.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};
    private static final Log log = LogFactory.getLog((Class)PackageBuilder.class);
    private static Kernel kernel;
    private static AbstractName targetConfigStoreAName;
    private static AbstractName targetRepositoryAName;
    private String repositoryClass;
    private String configurationStoreClass;
    private String targetRepositoryClass;
    private String targetConfigurationStoreClass;
    private File repository;
    private File targetRepository;
    private Collection deploymentConfigs;
    private AbstractName deployerName;
    private File planFile;
    private File moduleFile;
    private File packageFile;
    private String explicitResolutionLocation;
    private boolean targetSet;

    public String getRepositoryClass() {
        return this.repositoryClass;
    }

    public void setRepositoryClass(String repositoryClass) {
        this.repositoryClass = repositoryClass;
    }

    public String getConfigurationStoreClass() {
        return this.configurationStoreClass;
    }

    public void setConfigurationStoreClass(String configurationStoreClass) {
        this.configurationStoreClass = configurationStoreClass;
    }

    public File getRepository() {
        return this.repository;
    }

    public void setRepository(File repository) {
        this.repository = repository;
    }

    public String getTargetRepositoryClass() {
        return this.targetRepositoryClass;
    }

    public void setTargetRepositoryClass(String targetRepositoryClass) {
        this.targetRepositoryClass = targetRepositoryClass;
    }

    public String getTargetConfigurationStoreClass() {
        return this.targetConfigurationStoreClass;
    }

    public void setTargetConfigurationStoreClass(String targetConfigurationStoreClass) {
        this.targetConfigurationStoreClass = targetConfigurationStoreClass;
    }

    public File getTargetRepository() {
        return this.targetRepository;
    }

    public void setTargetRepository(File targetRepository) {
        this.targetRepository = targetRepository;
    }

    public Collection getDeploymentConfig() {
        return this.deploymentConfigs;
    }

    public void setDeploymentConfig(Collection deploymentConfigString) {
        this.deploymentConfigs = deploymentConfigString;
    }

    public String getDeployerName() {
        return this.deployerName.toString();
    }

    public void setDeployerName(String deployerName) {
        this.deployerName = new AbstractName(URI.create(deployerName));
    }

    public File getPlanFile() {
        return this.planFile;
    }

    public void setPlanFile(File planFile) {
        this.planFile = planFile;
    }

    public File getModuleFile() {
        return this.moduleFile;
    }

    public void setModuleFile(File moduleFile) {
        this.moduleFile = moduleFile;
    }

    public File getPackageFile() {
        return this.packageFile;
    }

    public void setPackageFile(File packageFile) {
        this.packageFile = packageFile;
    }

    public String getExplicitResolutionLocation() {
        return this.explicitResolutionLocation;
    }

    public void setExplicitResolutionLocation(String explicitResolutionLocation) {
        this.explicitResolutionLocation = explicitResolutionLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        System.out.println("Packaging module configuration: " + this.planFile);
        try {
            Kernel kernel = this.createKernel();
            if (!this.targetSet) {
                this.setTargetConfigStore();
            }
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
            try {
                Iterator iterator = this.deploymentConfigs.iterator();
                while (iterator.hasNext()) {
                    String artifactName = (String)iterator.next();
                    Artifact configName = Artifact.create((String)artifactName);
                    if (configurationManager.isLoaded(configName)) continue;
                    configurationManager.loadConfiguration(configName);
                    configurationManager.startConfiguration(configName);
                }
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)kernel, (ConfigurationManager)configurationManager);
            }
            AbstractName deployer = this.locateDeployer(kernel);
            this.invokeDeployer(kernel, deployer, targetConfigStoreAName.toString());
        }
        catch (Exception e) {
            log.error((Object)(e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    private void setTargetConfigStore() throws Exception {
        kernel.stopGBean(targetRepositoryAName);
        kernel.setAttribute(targetRepositoryAName, "root", (Object)this.targetRepository.toURI());
        kernel.startGBean(targetRepositoryAName);
        if (kernel.getGBeanState(targetConfigStoreAName) != 1) {
            throw new IllegalStateException("After restarted repository then config store is not running");
        }
        this.targetSet = true;
    }

    private synchronized Kernel createKernel() throws Exception {
        if (kernel != null) {
            return kernel;
        }
        kernel = KernelRegistry.getKernel((String)KERNEL_NAME);
        if (kernel != null) {
            return kernel;
        }
        GeronimoLogging geronimoLogging = GeronimoLogging.getGeronimoLogging((String)"WARN");
        if (geronimoLogging == null) {
            geronimoLogging = GeronimoLogging.DEBUG;
        }
        GeronimoLogging.initialize((GeronimoLogging)geronimoLogging);
        kernel = KernelFactory.newInstance().createKernel(KERNEL_NAME);
        kernel.boot();
        this.bootDeployerSystem();
        return kernel;
    }

    private void bootDeployerSystem() throws Exception {
        Artifact baseId = new Artifact("geronimo", "packaging", "fixed", "car");
        Naming naming = kernel.getNaming();
        ConfigurationData bootstrap = new ConfigurationData(baseId, naming);
        ClassLoader cl = PackageBuilder.class.getClassLoader();
        HashSet<AbstractName> repoNames = new HashSet<AbstractName>();
        GBeanData repoGBean = bootstrap.addGBean("SourceRepository", GBeanInfo.getGBeanInfo((String)this.repositoryClass, (ClassLoader)cl));
        URI repositoryURI = this.repository.toURI();
        repoGBean.setAttribute("root", (Object)repositoryURI);
        repoNames.add(repoGBean.getAbstractName());
        GBeanData targetRepoGBean = bootstrap.addGBean("TargetRepository", GBeanInfo.getGBeanInfo((String)this.targetRepositoryClass, (ClassLoader)cl));
        URI targetRepositoryURI = this.targetRepository.toURI();
        targetRepoGBean.setAttribute("root", (Object)targetRepositoryURI);
        repoNames.add(targetRepoGBean.getAbstractName());
        targetRepositoryAName = targetRepoGBean.getAbstractName();
        GBeanData artifactManagerGBean = bootstrap.addGBean("ArtifactManager", DefaultArtifactManager.GBEAN_INFO);
        GBeanData artifactResolverGBean = bootstrap.addGBean("ArtifactResolver", ExplicitDefaultArtifactResolver.GBEAN_INFO);
        artifactResolverGBean.setAttribute("versionMapLocation", (Object)this.explicitResolutionLocation);
        ReferencePatterns repoPatterns = new ReferencePatterns(repoNames);
        artifactResolverGBean.setReferencePatterns("Repositories", repoPatterns);
        artifactResolverGBean.setReferencePattern("ArtifactManager", artifactManagerGBean.getAbstractName());
        HashSet<AbstractName> storeNames = new HashSet<AbstractName>();
        GBeanInfo configStoreInfo = GBeanInfo.getGBeanInfo((String)this.configurationStoreClass, (ClassLoader)cl);
        GBeanData storeGBean = bootstrap.addGBean("ConfigStore", configStoreInfo);
        if (configStoreInfo.getReference("Repository") != null) {
            storeGBean.setReferencePattern("Repository", repoGBean.getAbstractName());
        }
        storeNames.add(storeGBean.getAbstractName());
        GBeanInfo targetConfigStoreInfo = GBeanInfo.getGBeanInfo((String)this.targetConfigurationStoreClass, (ClassLoader)cl);
        GBeanData targetStoreGBean = bootstrap.addGBean("TargetConfigStore", targetConfigStoreInfo);
        if (targetConfigStoreInfo.getReference("Repository") != null) {
            targetStoreGBean.setReferencePattern("Repository", targetRepoGBean.getAbstractName());
        }
        storeNames.add(targetStoreGBean.getAbstractName());
        targetConfigStoreAName = targetStoreGBean.getAbstractName();
        this.targetSet = true;
        GBeanData attrManagerGBean = bootstrap.addGBean("AttributeStore", MavenAttributeStore.GBEAN_INFO);
        GBeanData configManagerGBean = bootstrap.addGBean("ConfigManager", KernelConfigurationManager.GBEAN_INFO);
        configManagerGBean.setReferencePatterns("Stores", new ReferencePatterns(storeNames));
        configManagerGBean.setReferencePattern("AttributeStore", attrManagerGBean.getAbstractName());
        configManagerGBean.setReferencePattern("ArtifactManager", artifactManagerGBean.getAbstractName());
        configManagerGBean.setReferencePattern("ArtifactResolver", artifactResolverGBean.getAbstractName());
        configManagerGBean.setReferencePatterns("Repositories", repoPatterns);
        ConfigurationUtil.loadBootstrapConfiguration((Kernel)kernel, (ConfigurationData)bootstrap, (ClassLoader)cl);
    }

    private AbstractName locateDeployer(Kernel kernel) {
        Iterator i = kernel.listGBeans(new AbstractNameQuery(this.deployerName)).iterator();
        if (!i.hasNext()) {
            throw new IllegalStateException("No deployer found matching deployerName: " + this.deployerName);
        }
        AbstractName deployer = (AbstractName)i.next();
        if (i.hasNext()) {
            throw new IllegalStateException("Multiple deployers found matching deployerName: " + this.deployerName);
        }
        return deployer;
    }

    private List invokeDeployer(Kernel kernel, AbstractName deployer, String targetConfigStore) throws Exception {
        Object[] args = new Object[]{Boolean.FALSE, this.planFile, this.moduleFile, null, Boolean.TRUE, null, null, null, null, null, null, null, targetConfigStore};
        return (List)kernel.invoke(deployer, "deploy", args, ARG_TYPES);
    }
}

