/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.plugin.car;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.plugin.car.AbstractCarMojo;
import org.apache.geronimo.plugin.car.ArtifactItem;
import org.apache.geronimo.plugin.car.ClasspathElement;
import org.apache.geronimo.plugin.car.MavenConfigStore;
import org.apache.geronimo.plugin.car.PackageBuilder;
import org.apache.geronimo.system.configuration.RepositoryConfigurationStore;
import org.apache.geronimo.system.repository.Maven2Repository;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;

public class PackageMojo
extends AbstractCarMojo {
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private JarArchiver jarArchiver = null;
    private File outputDirectory = null;
    private File classesDirectory = null;
    private String finalName = null;
    private File repository = null;
    private File targetRepository = null;
    private String deafultDeploymentConfig = null;
    private ArrayList deploymentConfigs;
    private String deployerName = null;
    private File planFile = null;
    private File moduleFile = null;
    private ArtifactItem module = null;
    private File explicitResolutionProperties = null;
    private List classpath = null;
    private String classpathPrefix = null;

    protected void doExecute() throws Exception {
        FileUtils.forceDelete((File)this.targetRepository);
        FileUtils.forceMkdir((File)this.targetRepository);
        if (this.deploymentConfigs == null) {
            this.deploymentConfigs = new ArrayList();
            this.deploymentConfigs.add(this.deafultDeploymentConfig);
        }
        this.log.debug((CharSequence)("Deployment configs: " + this.deploymentConfigs));
        if (this.module != null) {
            Artifact artifact = this.getArtifact(this.module);
            this.moduleFile = artifact.getFile();
            this.log.debug((CharSequence)("Using module file: " + this.moduleFile));
        }
        this.generateExplicitVersionProperties(this.explicitResolutionProperties);
        this.executePackageBuilderShell();
        File archive = this.createArchive();
        this.project.getArtifact().setFile(archive);
    }

    private File getArtifactInRepositoryDir() {
        File dir = new File(this.targetRepository, this.project.getGroupId().replace('.', '/'));
        dir = new File(dir, this.project.getArtifactId());
        dir = new File(dir, this.project.getVersion());
        dir = new File(dir, this.project.getArtifactId() + "-" + this.project.getVersion() + ".car");
        return dir;
    }

    public void executePackageBuilderShell() throws Exception {
        this.log.debug((CharSequence)"Starting builder shell...");
        PackageBuilder builder = new PackageBuilder();
        builder.setDeployerName(this.deployerName);
        builder.setDeploymentConfig(this.deploymentConfigs);
        builder.setModuleFile(this.moduleFile);
        builder.setPlanFile(this.planFile);
        builder.setRepository(this.repository);
        builder.setRepositoryClass(Maven2Repository.class.getName());
        builder.setConfigurationStoreClass(MavenConfigStore.class.getName());
        builder.setTargetRepository(this.targetRepository);
        builder.setTargetRepositoryClass(Maven2Repository.class.getName());
        builder.setTargetConfigurationStoreClass(RepositoryConfigurationStore.class.getName());
        builder.setExplicitResolutionLocation(this.explicitResolutionProperties.getAbsolutePath());
        builder.execute();
    }

    private File createArchive() throws MojoExecutionException {
        File archiveFile = PackageMojo.getArchiveFile(this.outputDirectory, this.finalName, null);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(archiveFile);
        try {
            archiver.getArchiver().addDirectory(this.getArtifactInRepositoryDir());
            archiver.getArchiver().addDirectory(this.classesDirectory);
            if (this.classpath != null) {
                this.archive.addManifestEntry((Object)"Class-Path", (Object)this.getClassPath());
            }
            archiver.createArchive(this.project, this.archive);
            return archiveFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create archive", e);
        }
    }

    private String getClassPath() throws MojoExecutionException {
        StringBuffer buff = new StringBuffer();
        ClasspathElement[] elements = this.classpath.toArray(new ClasspathElement[this.classpath.size()]);
        for (int i = 0; i < elements.length; ++i) {
            Artifact artifact = this.getArtifact(elements[i]);
            String prefix = elements[i].getClasspathPrefix();
            if (prefix == null) {
                prefix = this.classpathPrefix;
            }
            if (prefix != null) {
                buff.append(prefix);
                if (!prefix.endsWith("/")) {
                    buff.append("/");
                }
            }
            File file = artifact.getFile();
            buff.append(file.getName());
            if (i + 1 >= elements.length) continue;
            buff.append(" ");
        }
        this.log.debug((CharSequence)("Using classpath: " + buff));
        return buff.toString();
    }
}

