/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.plugin.car;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xbeans.ArtifactType;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.plugin.car.AbstractCarMojo;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class PlanProcessorMojo
extends AbstractCarMojo {
    private static final String ENVIRONMENT_LOCAL_NAME = "environment";
    private static final QName ENVIRONMENT_QNAME = new QName("http://geronimo.apache.org/xml/ns/deployment-1.1", "environment");
    private File sourceDir;
    private File targetDir;
    private String planFileName;
    private File targetFile;
    private String geronimoVersion;

    private VelocityContext createContext() {
        VelocityContext context = new VelocityContext();
        Properties props = this.project.getProperties();
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = props.getProperty(key);
            this.log.debug((CharSequence)("Setting " + key + "=" + value));
            context.put(key, (Object)value);
        }
        context.put("pom", (Object)this.project);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() throws Exception {
        VelocityContext context = this.createContext();
        VelocityEngine velocity = new VelocityEngine();
        velocity.setProperty("file.resource.loader.path", (Object)this.sourceDir.getAbsolutePath());
        velocity.init();
        Template template = velocity.getTemplate(this.planFileName);
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        String plan = writer.toString();
        XmlObject doc = XmlObject.Factory.parse((String)plan);
        XmlCursor xmlCursor = doc.newCursor();
        LinkedHashSet dependencies = this.toDependencies();
        Artifact configId = new Artifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "car");
        try {
            this.mergeEnvironment(xmlCursor, configId, dependencies);
            if (this.targetDir.exists()) {
                if (!this.targetDir.isDirectory()) {
                    throw new RuntimeException("TargetDir: " + this.targetDir + " exists and is not a directory");
                }
            } else {
                this.targetDir.mkdirs();
            }
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setSavePrettyPrint();
            doc.save(this.targetFile, xmlOptions);
            this.log.info((CharSequence)("Generated: " + this.targetFile));
        }
        finally {
            xmlCursor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeEnvironment(XmlCursor xmlCursor, Artifact configId, LinkedHashSet dependencies) {
        Environment oldEnvironment;
        EnvironmentType environmentType;
        xmlCursor.toFirstContentToken();
        xmlCursor.toFirstChild();
        QName childName = xmlCursor.getName();
        if (childName != null && childName.getLocalPart().equals(ENVIRONMENT_LOCAL_NAME)) {
            this.convertElement(xmlCursor, ENVIRONMENT_QNAME.getNamespaceURI());
            XmlObject xmlObject = xmlCursor.getObject();
            environmentType = (EnvironmentType)xmlObject.copy().changeType(EnvironmentType.type);
            oldEnvironment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType);
            xmlCursor.removeXml();
        } else {
            oldEnvironment = new Environment();
        }
        Environment newEnvironment = new Environment();
        newEnvironment.setConfigId(configId);
        newEnvironment.setDependencies((Collection)dependencies);
        EnvironmentBuilder.mergeEnvironments((Environment)oldEnvironment, (Environment)newEnvironment);
        environmentType = EnvironmentBuilder.buildEnvironmentType((Environment)oldEnvironment);
        xmlCursor.beginElement(ENVIRONMENT_QNAME);
        XmlCursor element = environmentType.newCursor();
        try {
            element.copyXmlContents(xmlCursor);
        }
        finally {
            element.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertElement(XmlCursor cursor, String namespace) {
        cursor.push();
        XmlCursor end = cursor.newCursor();
        try {
            end.toCursor(cursor);
            end.toEndToken();
            while (cursor.hasNextToken() && cursor.isLeftOf(end)) {
                if (cursor.isStart() && !namespace.equals(cursor.getName().getNamespaceURI())) {
                    cursor.setName(new QName(namespace, cursor.getName().getLocalPart()));
                }
                cursor.toNextToken();
            }
            cursor.pop();
        }
        finally {
            end.dispose();
        }
    }

    private LinkedHashSet toDependencies() {
        List artifacts = this.project.getDependencies();
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Dependency gdep;
            org.apache.maven.model.Dependency dependency = (org.apache.maven.model.Dependency)iter.next();
            if (dependency.getGroupId().startsWith("org.apache.geronimo.genesis") || (gdep = PlanProcessorMojo.toGeronimoDependency(dependency)) == null) continue;
            dependencies.add(gdep);
        }
        return dependencies;
    }

    private static Dependency toGeronimoDependency(org.apache.maven.model.Dependency dependency) {
        Artifact artifact = PlanProcessorMojo.toGeronimoArtifact(dependency);
        String type = dependency.getType();
        String scope = dependency.getScope();
        String groupId = dependency.getGroupId();
        if (!(!"jar".equalsIgnoreCase(type) || "junit".equals(groupId) || scope != null && scope.equals("provided"))) {
            if (dependency.getVersion() != null) {
                artifact = new Artifact(artifact.getGroupId(), artifact.getArtifactId(), dependency.getVersion(), artifact.getType());
            }
            return new Dependency(artifact, ImportType.CLASSES);
        }
        if ("car".equalsIgnoreCase(type) && "runtime".equalsIgnoreCase(scope)) {
            return new Dependency(artifact, ImportType.SERVICES);
        }
        if ("car".equalsIgnoreCase(type) && "compile".equalsIgnoreCase(scope)) {
            return new Dependency(artifact, ImportType.CLASSES);
        }
        if ("car".equalsIgnoreCase(type) && scope == null) {
            return new Dependency(artifact, ImportType.ALL);
        }
        return null;
    }

    private static Artifact toGeronimoArtifact(org.apache.maven.model.Dependency dependency) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        String version = null;
        String type = dependency.getType();
        return new Artifact(groupId, artifactId, version, type);
    }

    static interface Inserter {
        public ArtifactType insert(EnvironmentType var1);
    }
}

