/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.servlet;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.servlet.GuacamoleHTTPTunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GuacamoleHTTPTunnelMap {
    private static final Logger logger = LoggerFactory.getLogger(GuacamoleHTTPTunnelMap.class);
    private static final int TUNNEL_TIMEOUT = 15;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private final ConcurrentMap<String, GuacamoleHTTPTunnel> tunnelMap = new ConcurrentHashMap<String, GuacamoleHTTPTunnel>();

    public GuacamoleHTTPTunnelMap() {
        this.executor.scheduleAtFixedRate(new TunnelTimeoutTask(15000L), 15L, 15L, TimeUnit.SECONDS);
    }

    public GuacamoleHTTPTunnel get(String uuid) {
        GuacamoleHTTPTunnel tunnel = (GuacamoleHTTPTunnel)this.tunnelMap.get(uuid);
        if (tunnel != null) {
            tunnel.access();
        }
        return tunnel;
    }

    public void put(String uuid, GuacamoleTunnel tunnel) {
        this.tunnelMap.put(uuid, new GuacamoleHTTPTunnel(tunnel));
    }

    public GuacamoleHTTPTunnel remove(String uuid) {
        return (GuacamoleHTTPTunnel)this.tunnelMap.remove(uuid);
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    private class TunnelTimeoutTask
    implements Runnable {
        private final long tunnelTimeout;

        public TunnelTimeoutTask(long tunnelTimeout) {
            this.tunnelTimeout = tunnelTimeout;
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            Iterator entries = GuacamoleHTTPTunnelMap.this.tunnelMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                GuacamoleHTTPTunnel tunnel = (GuacamoleHTTPTunnel)entry.getValue();
                long age = now - tunnel.getLastAccessedTime();
                if (age < this.tunnelTimeout) continue;
                logger.debug("HTTP tunnel \"{}\" has timed out.", entry.getKey());
                entries.remove();
                try {
                    tunnel.close();
                }
                catch (GuacamoleException e) {
                    logger.debug("Unable to close expired HTTP tunnel.", (Throwable)e);
                }
            }
        }
    }
}

