/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.servlet;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleConnectionClosedException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.io.GuacamoleReader;
import org.apache.guacamole.io.GuacamoleWriter;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.protocol.GuacamoleStatus;
import org.apache.guacamole.servlet.GuacamoleHTTPTunnel;
import org.apache.guacamole.servlet.GuacamoleHTTPTunnelMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuacamoleHTTPTunnelServlet
extends HttpServlet {
    private final Logger logger = LoggerFactory.getLogger(GuacamoleHTTPTunnelServlet.class);
    private final GuacamoleHTTPTunnelMap tunnels = new GuacamoleHTTPTunnelMap();
    private static final String READ_PREFIX = "read:";
    private static final String WRITE_PREFIX = "write:";
    private static final int READ_PREFIX_LENGTH = "read:".length();
    private static final int WRITE_PREFIX_LENGTH = "write:".length();
    private static final int UUID_LENGTH = 36;

    protected void registerTunnel(GuacamoleTunnel tunnel) {
        this.tunnels.put(tunnel.getUUID().toString(), tunnel);
        this.logger.debug("Registered tunnel \"{}\".", (Object)tunnel.getUUID());
    }

    protected void deregisterTunnel(GuacamoleTunnel tunnel) {
        this.tunnels.remove(tunnel.getUUID().toString());
        this.logger.debug("Deregistered tunnel \"{}\".", (Object)tunnel.getUUID());
    }

    protected GuacamoleTunnel getTunnel(String tunnelUUID) throws GuacamoleException {
        GuacamoleHTTPTunnel tunnel = this.tunnels.get(tunnelUUID);
        if (tunnel == null) {
            throw new GuacamoleResourceNotFoundException("No such tunnel.");
        }
        return tunnel;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.handleTunnelRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.handleTunnelRequest(request, response);
    }

    protected void sendError(HttpServletResponse response, GuacamoleStatus guacStatus, String message) throws ServletException {
        try {
            if (!response.isCommitted()) {
                response.addHeader("Guacamole-Status-Code", Integer.toString(guacStatus.getGuacamoleStatusCode()));
                response.addHeader("Guacamole-Error-Message", message);
                response.sendError(guacStatus.getHttpStatusCode());
            }
        }
        catch (IOException ioe) {
            throw new ServletException((Throwable)ioe);
        }
    }

    protected void handleTunnelRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        block10: {
            try {
                String query = request.getQueryString();
                if (query == null) {
                    throw new GuacamoleClientException("No query string provided.");
                }
                if (query.equals("connect")) {
                    GuacamoleTunnel tunnel = this.doConnect(request);
                    if (tunnel != null) {
                        this.registerTunnel(tunnel);
                        try {
                            response.setHeader("Cache-Control", "no-cache");
                            response.getWriter().print(tunnel.getUUID().toString());
                            break block10;
                        }
                        catch (IOException e) {
                            throw new GuacamoleServerException(e);
                        }
                    }
                    throw new GuacamoleResourceNotFoundException("No tunnel created.");
                }
                if (query.startsWith(READ_PREFIX)) {
                    this.doRead(request, response, query.substring(READ_PREFIX_LENGTH, READ_PREFIX_LENGTH + 36));
                    break block10;
                }
                if (query.startsWith(WRITE_PREFIX)) {
                    this.doWrite(request, response, query.substring(WRITE_PREFIX_LENGTH, WRITE_PREFIX_LENGTH + 36));
                    break block10;
                }
                throw new GuacamoleClientException("Invalid tunnel operation: " + query);
            }
            catch (GuacamoleClientException e) {
                this.logger.warn("HTTP tunnel request rejected: {}", (Object)e.getMessage());
                this.sendError(response, e.getStatus(), e.getMessage());
            }
            catch (GuacamoleException e) {
                this.logger.error("HTTP tunnel request failed: {}", (Object)e.getMessage());
                this.logger.debug("Internal error in HTTP tunnel.", (Throwable)e);
                this.sendError(response, e.getStatus(), "Internal server error.");
            }
        }
    }

    protected abstract GuacamoleTunnel doConnect(HttpServletRequest var1) throws GuacamoleException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRead(HttpServletRequest request, HttpServletResponse response, String tunnelUUID) throws GuacamoleException {
        GuacamoleTunnel tunnel = this.getTunnel(tunnelUUID);
        if (!tunnel.isOpen()) {
            throw new GuacamoleResourceNotFoundException("Tunnel is closed.");
        }
        GuacamoleReader reader = tunnel.acquireReader();
        try {
            response.setContentType("application/octet-stream");
            response.setHeader("Cache-Control", "no-cache");
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
            try {
                char[] message = reader.read();
                if (message == null) {
                    throw new GuacamoleConnectionClosedException("Tunnel reached end of stream.");
                }
                do {
                    ((Writer)out).write(message, 0, message.length);
                    if (reader.available()) continue;
                    ((Writer)out).flush();
                    response.flushBuffer();
                } while (!tunnel.hasQueuedReaderThreads() && tunnel.isOpen() && (message = reader.read()) != null);
                if (message == null) {
                    this.deregisterTunnel(tunnel);
                    tunnel.close();
                }
                out.write("0.;");
                ((Writer)out).flush();
                response.flushBuffer();
            }
            catch (GuacamoleConnectionClosedException e) {
                this.deregisterTunnel(tunnel);
                tunnel.close();
                out.write("0.;");
                ((Writer)out).flush();
                response.flushBuffer();
            }
            catch (GuacamoleException e) {
                this.deregisterTunnel(tunnel);
                tunnel.close();
                throw e;
            }
            finally {
                ((Writer)out).close();
            }
        }
        catch (IOException e) {
            this.logger.debug("Error writing to servlet output stream", (Throwable)e);
            this.deregisterTunnel(tunnel);
            tunnel.close();
        }
        finally {
            tunnel.releaseReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWrite(HttpServletRequest request, HttpServletResponse response, String tunnelUUID) throws GuacamoleException {
        GuacamoleTunnel tunnel = this.getTunnel(tunnelUUID);
        response.setContentType("application/octet-stream");
        response.setHeader("Cache-Control", "no-cache");
        response.setContentLength(0);
        try {
            GuacamoleWriter writer = tunnel.acquireWriter();
            InputStreamReader input = new InputStreamReader((InputStream)request.getInputStream(), "UTF-8");
            try {
                int length;
                char[] buffer = new char[8192];
                while (tunnel.isOpen() && (length = ((Reader)input).read(buffer, 0, buffer.length)) != -1) {
                    writer.write(buffer, 0, length);
                }
            }
            finally {
                ((Reader)input).close();
            }
        }
        catch (GuacamoleConnectionClosedException e) {
            this.logger.debug("Connection to guacd closed.", (Throwable)e);
        }
        catch (IOException e) {
            this.deregisterTunnel(tunnel);
            tunnel.close();
            throw new GuacamoleServerException("I/O Error sending data to server: " + e.getMessage(), e);
        }
        finally {
            tunnel.releaseWriter();
        }
    }

    public void destroy() {
        this.tunnels.shutdown();
    }
}

