/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.websocket;

import java.io.IOException;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleConnectionClosedException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.io.GuacamoleReader;
import org.apache.guacamole.io.GuacamoleWriter;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.protocol.GuacamoleInstruction;
import org.apache.guacamole.protocol.GuacamoleStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuacamoleWebSocketTunnelEndpoint
extends Endpoint {
    private static final int BUFFER_SIZE = 8192;
    private final Logger logger = LoggerFactory.getLogger(GuacamoleWebSocketTunnelEndpoint.class);
    private GuacamoleTunnel tunnel;

    private void closeConnection(Session session, GuacamoleStatus guac_status) {
        try {
            CloseReason.CloseCode code = CloseReason.CloseCodes.getCloseCode((int)guac_status.getWebSocketCode());
            String message = Integer.toString(guac_status.getGuacamoleStatusCode());
            session.close(new CloseReason(code, message));
        }
        catch (IOException e) {
            this.logger.debug("Unable to close WebSocket connection.", (Throwable)e);
        }
    }

    protected abstract GuacamoleTunnel createTunnel(Session var1, EndpointConfig var2) throws GuacamoleException;

    @OnOpen
    public void onOpen(final Session session, EndpointConfig config) {
        try {
            this.tunnel = this.createTunnel(session, config);
            if (this.tunnel == null) {
                this.closeConnection(session, GuacamoleStatus.RESOURCE_NOT_FOUND);
                return;
            }
        }
        catch (GuacamoleException e) {
            this.logger.error("Creation of WebSocket tunnel to guacd failed: {}", (Object)e.getMessage());
            this.logger.debug("Error connecting WebSocket tunnel.", (Throwable)e);
            this.closeConnection(session, e.getStatus());
            return;
        }
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String message) {
                GuacamoleWebSocketTunnelEndpoint.this.onMessage(message);
            }
        });
        Thread readThread = new Thread(){
            private final RemoteEndpoint.Basic remote;
            {
                this.remote = session.getBasicRemote();
            }

            @Override
            public void run() {
                StringBuilder buffer = new StringBuilder(8192);
                GuacamoleReader reader = GuacamoleWebSocketTunnelEndpoint.this.tunnel.acquireReader();
                try {
                    this.remote.sendText(new GuacamoleInstruction("", GuacamoleWebSocketTunnelEndpoint.this.tunnel.getUUID().toString()).toString());
                    try {
                        char[] readMessage;
                        while ((readMessage = reader.read()) != null) {
                            buffer.append(readMessage);
                            if (reader.available() && buffer.length() < 8192) continue;
                            this.remote.sendText(buffer.toString());
                            buffer.setLength(0);
                        }
                        GuacamoleWebSocketTunnelEndpoint.this.closeConnection(session, GuacamoleStatus.SUCCESS);
                    }
                    catch (GuacamoleClientException e) {
                        GuacamoleWebSocketTunnelEndpoint.this.logger.info("WebSocket connection terminated: {}", (Object)e.getMessage());
                        GuacamoleWebSocketTunnelEndpoint.this.logger.debug("WebSocket connection terminated due to client error.", (Throwable)e);
                        GuacamoleWebSocketTunnelEndpoint.this.closeConnection(session, e.getStatus());
                    }
                    catch (GuacamoleConnectionClosedException e) {
                        GuacamoleWebSocketTunnelEndpoint.this.logger.debug("Connection to guacd closed.", (Throwable)e);
                        GuacamoleWebSocketTunnelEndpoint.this.closeConnection(session, GuacamoleStatus.SUCCESS);
                    }
                    catch (GuacamoleException e) {
                        GuacamoleWebSocketTunnelEndpoint.this.logger.error("Connection to guacd terminated abnormally: {}", (Object)e.getMessage());
                        GuacamoleWebSocketTunnelEndpoint.this.logger.debug("Internal error during connection to guacd.", (Throwable)e);
                        GuacamoleWebSocketTunnelEndpoint.this.closeConnection(session, e.getStatus());
                    }
                }
                catch (IOException e) {
                    GuacamoleWebSocketTunnelEndpoint.this.logger.debug("I/O error prevents further reads.", (Throwable)e);
                    GuacamoleWebSocketTunnelEndpoint.this.closeConnection(session, GuacamoleStatus.SERVER_ERROR);
                }
            }
        };
        readThread.start();
    }

    @OnMessage
    public void onMessage(String message) {
        if (this.tunnel == null) {
            return;
        }
        GuacamoleWriter writer = this.tunnel.acquireWriter();
        try {
            writer.write(message.toCharArray());
        }
        catch (GuacamoleConnectionClosedException e) {
            this.logger.debug("Connection to guacd closed.", (Throwable)e);
        }
        catch (GuacamoleException e) {
            this.logger.debug("WebSocket tunnel write failed.", (Throwable)e);
        }
        this.tunnel.releaseWriter();
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        try {
            if (this.tunnel != null) {
                this.tunnel.close();
            }
        }
        catch (GuacamoleException e) {
            this.logger.debug("Unable to close WebSocket tunnel.", (Throwable)e);
        }
    }
}

