/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.protocol;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GuacamoleProtocolVersion {
    public static final GuacamoleProtocolVersion VERSION_1_0_0 = new GuacamoleProtocolVersion(1, 0, 0);
    public static final GuacamoleProtocolVersion VERSION_1_1_0 = new GuacamoleProtocolVersion(1, 1, 0);
    public static final GuacamoleProtocolVersion VERSION_1_3_0;
    public static final GuacamoleProtocolVersion LATEST;
    private static final Pattern VERSION_PATTERN;
    private final int major;
    private final int minor;
    private final int patch;

    public GuacamoleProtocolVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean atLeast(GuacamoleProtocolVersion otherVersion) {
        if (this.major != otherVersion.getMajor()) {
            return this.major > otherVersion.getMajor();
        }
        if (this.minor != otherVersion.getMinor()) {
            return this.minor > otherVersion.getMinor();
        }
        return this.patch >= otherVersion.getPatch();
    }

    public static GuacamoleProtocolVersion parseVersion(String version) {
        Matcher versionMatcher = VERSION_PATTERN.matcher(version);
        if (!versionMatcher.matches()) {
            return null;
        }
        return new GuacamoleProtocolVersion(Integer.parseInt(versionMatcher.group(1)), Integer.parseInt(versionMatcher.group(2)), Integer.parseInt(versionMatcher.group(3)));
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + this.major;
        hash = 61 * hash + this.minor;
        hash = 61 * hash + this.patch;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GuacamoleProtocolVersion)) {
            return false;
        }
        GuacamoleProtocolVersion otherVersion = (GuacamoleProtocolVersion)obj;
        return this.major == otherVersion.getMajor() && this.minor == otherVersion.getMinor() && this.patch == otherVersion.getPatch();
    }

    public String toString() {
        return "VERSION_" + this.getMajor() + "_" + this.getMinor() + "_" + this.getPatch();
    }

    static {
        LATEST = VERSION_1_3_0 = new GuacamoleProtocolVersion(1, 3, 0);
        VERSION_PATTERN = Pattern.compile("^VERSION_([0-9]+)_([0-9]+)_([0-9]+)$");
    }
}

