/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.CredentialInitializationException;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.security.ProviderUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TemporaryAWSCredentialsProvider
implements AWSCredentialsProvider {
    public static final String NAME = "org.apache.hadoop.fs.s3a.TemporaryAWSCredentialsProvider";
    private String accessKey;
    private String secretKey;
    private String sessionToken;

    public TemporaryAWSCredentialsProvider(Configuration conf) throws IOException {
        this(null, conf);
    }

    public TemporaryAWSCredentialsProvider(URI uri, Configuration conf) throws IOException {
        String bucket = uri != null ? uri.getHost() : "";
        Configuration c = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)conf, S3AFileSystem.class);
        this.accessKey = S3AUtils.lookupPassword(bucket, c, "fs.s3a.access.key");
        this.secretKey = S3AUtils.lookupPassword(bucket, c, "fs.s3a.secret.key");
        this.sessionToken = S3AUtils.lookupPassword(bucket, c, "fs.s3a.session.token");
    }

    public AWSCredentials getCredentials() {
        if (!(StringUtils.isEmpty((CharSequence)this.accessKey) || StringUtils.isEmpty((CharSequence)this.secretKey) || StringUtils.isEmpty((CharSequence)this.sessionToken))) {
            return new BasicSessionCredentials(this.accessKey, this.secretKey, this.sessionToken);
        }
        throw new CredentialInitializationException("Access key, secret key or session token is unset");
    }

    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

