/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;

public final class MagicCommitPaths {
    private MagicCommitPaths() {
    }

    public static List<String> splitPathToElements(Path path) {
        Preconditions.checkArgument((boolean)path.isAbsolute(), (Object)"path is relative");
        String uriPath = path.toUri().getPath();
        Preconditions.checkArgument((!uriPath.isEmpty() ? 1 : 0) != 0, (Object)"empty path");
        if ("/".equals(uriPath)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> elements = new ArrayList<String>();
        int len = uriPath.length();
        int firstElementChar = 1;
        int endOfElement = uriPath.indexOf(47, firstElementChar);
        while (endOfElement > 0) {
            elements.add(uriPath.substring(firstElementChar, endOfElement));
            firstElementChar = endOfElement + 1;
            endOfElement = firstElementChar == len ? -1 : uriPath.indexOf(47, firstElementChar);
        }
        if (firstElementChar != len) {
            elements.add(uriPath.substring(firstElementChar));
        }
        return elements;
    }

    public static boolean isMagicPath(List<String> elements) {
        return elements.contains("__magic");
    }

    public static boolean containsBasePath(List<String> elements) {
        return elements.contains("__base");
    }

    public static int magicElementIndex(List<String> elements) {
        int index = elements.indexOf("__magic");
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"No __magic element in path");
        return index;
    }

    public static List<String> magicPathParents(List<String> elements) {
        return elements.subList(0, MagicCommitPaths.magicElementIndex(elements));
    }

    public static List<String> magicPathChildren(List<String> elements) {
        int len;
        int index = MagicCommitPaths.magicElementIndex(elements);
        if (index == (len = elements.size()) - 1) {
            return Collections.emptyList();
        }
        return elements.subList(index + 1, len);
    }

    public static List<String> basePathChildren(List<String> elements) {
        int index = elements.indexOf("__base");
        if (index < 0) {
            return Collections.emptyList();
        }
        int len = elements.size();
        if (index == len - 1) {
            return Collections.emptyList();
        }
        return elements.subList(index + 1, len);
    }

    public static String elementsToKey(List<String> elements) {
        return StringUtils.join((CharSequence)"/", elements);
    }

    public static String filename(List<String> elements) {
        return MagicCommitPaths.lastElement(elements);
    }

    public static String lastElement(List<String> strings) {
        Preconditions.checkArgument((!strings.isEmpty() ? 1 : 0) != 0, (Object)"empty list");
        return strings.get(strings.size() - 1);
    }

    public static Path magicSubdir(Path destDir) {
        return new Path(destDir, "__magic");
    }

    public static List<String> finalDestination(List<String> elements) {
        if (MagicCommitPaths.isMagicPath(elements)) {
            List<String> destDir = MagicCommitPaths.magicPathParents(elements);
            List<String> children = MagicCommitPaths.magicPathChildren(elements);
            Preconditions.checkArgument((!children.isEmpty() ? 1 : 0) != 0, (Object)"No path found under __magic");
            ArrayList<String> dest = new ArrayList<String>(destDir);
            if (MagicCommitPaths.containsBasePath(children)) {
                List<String> baseChildren = MagicCommitPaths.basePathChildren(children);
                Preconditions.checkArgument((!baseChildren.isEmpty() ? 1 : 0) != 0, (Object)"No path found under __base");
                dest.addAll(baseChildren);
            } else {
                dest.add(MagicCommitPaths.filename(children));
            }
            return dest;
        }
        return elements;
    }
}

