/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.LocalMetadataEntry;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadataDynamoDBTranslation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMetadataStore
implements MetadataStore {
    public static final Logger LOG = LoggerFactory.getLogger(MetadataStore.class);
    private Cache<Path, LocalMetadataEntry> localCache;
    private FileSystem fs;
    private String uriHost;

    @Override
    public void initialize(FileSystem fileSystem) throws IOException {
        Preconditions.checkNotNull((Object)fileSystem);
        this.fs = fileSystem;
        URI fsURI = this.fs.getUri();
        this.uriHost = fsURI.getHost();
        if (this.uriHost != null && this.uriHost.equals("")) {
            this.uriHost = null;
        }
        this.initialize(this.fs.getConf());
    }

    @Override
    public void initialize(Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)conf);
        int maxRecords = conf.getInt("fs.s3a.s3guard.local.max_records", 256);
        if (maxRecords < 4) {
            maxRecords = 4;
        }
        int ttl = conf.getInt("fs.s3a.s3guard.local.ttl", 10000);
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize((long)maxRecords);
        if (ttl >= 0) {
            builder.expireAfterAccess((long)ttl, TimeUnit.MILLISECONDS);
        }
        this.localCache = builder.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LocalMetadataStore{");
        sb.append("uriHost='").append(this.uriHost).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void delete(Path p) throws IOException {
        this.doDelete(p, false, true);
    }

    @Override
    public void forgetMetadata(Path p) throws IOException {
        this.doDelete(p, false, false);
    }

    @Override
    public void deleteSubtree(Path path) throws IOException {
        this.doDelete(path, true, true);
    }

    private synchronized void doDelete(Path p, boolean recursive, boolean tombstone) {
        Path path = this.standardize(p);
        this.deleteCacheEntries(path, tombstone);
        if (recursive) {
            LocalMetadataStore.deleteEntryByAncestor(path, this.localCache, tombstone);
        }
    }

    @Override
    public synchronized PathMetadata get(Path p) throws IOException {
        return this.get(p, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PathMetadata get(Path p, boolean wantEmptyDirectoryFlag) throws IOException {
        Path path = this.standardize(p);
        LocalMetadataStore localMetadataStore = this;
        synchronized (localMetadataStore) {
            PathMetadata m = this.getFileMeta(path);
            if (wantEmptyDirectoryFlag && m != null && m.getFileStatus().isDirectory()) {
                m.setIsEmptyDirectory(this.isEmptyDirectory(p));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("get({}) -> {}", (Object)path, (Object)(m == null ? "null" : m.prettyPrint()));
            }
            return m;
        }
    }

    private Tristate isEmptyDirectory(Path p) {
        DirListingMetadata dlm = this.getDirListingMeta(p);
        return dlm.withoutTombstones().isEmpty();
    }

    @Override
    public synchronized DirListingMetadata listChildren(Path p) throws IOException {
        Path path = this.standardize(p);
        DirListingMetadata listing = this.getDirListingMeta(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("listChildren({}) -> {}", (Object)path, (Object)(listing == null ? "null" : listing.prettyPrint()));
        }
        return listing == null ? null : new DirListingMetadata(listing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Collection<Path> pathsToDelete, Collection<PathMetadata> pathsToCreate) throws IOException {
        LOG.info("Move {} to {}", pathsToDelete, pathsToCreate);
        Preconditions.checkNotNull(pathsToDelete, (Object)"pathsToDelete is null");
        Preconditions.checkNotNull(pathsToCreate, (Object)"pathsToCreate is null");
        Preconditions.checkArgument((pathsToDelete.size() == pathsToCreate.size() ? 1 : 0) != 0, (Object)"Must supply same number of paths to delete/create.");
        LocalMetadataStore localMetadataStore = this;
        synchronized (localMetadataStore) {
            for (Path path : pathsToDelete) {
                LOG.debug("move: deleting metadata {}", (Object)path);
                this.delete(path);
            }
            for (PathMetadata pathMetadata : pathsToCreate) {
                LOG.debug("move: adding metadata {}", (Object)pathMetadata);
                this.put(pathMetadata);
            }
            for (PathMetadata pathMetadata : pathsToCreate) {
                DirListingMetadata dir;
                FileStatus status = pathMetadata.getFileStatus();
                if (status == null || status.isDirectory() || (dir = this.listChildren(status.getPath())) == null) continue;
                dir.setAuthoritative(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(PathMetadata meta) throws IOException {
        Preconditions.checkNotNull((Object)meta);
        FileStatus status = meta.getFileStatus();
        Path path = this.standardize(status.getPath());
        LocalMetadataStore localMetadataStore = this;
        synchronized (localMetadataStore) {
            LocalMetadataEntry entry;
            if (LOG.isDebugEnabled()) {
                LOG.debug("put {} -> {}", (Object)path, (Object)meta.prettyPrint());
            }
            if ((entry = (LocalMetadataEntry)this.localCache.getIfPresent((Object)path)) == null) {
                entry = new LocalMetadataEntry(meta);
            } else {
                entry.setPathMetadata(meta);
            }
            if (status.isDirectory() && !entry.hasDirMeta()) {
                DirListingMetadata dlm = new DirListingMetadata(path, DirListingMetadata.EMPTY_DIR, false);
                entry.setDirListingMetadata(dlm);
            }
            this.localCache.put((Object)path, (Object)entry);
            Path parentPath = path.getParent();
            if (parentPath != null) {
                LocalMetadataEntry parentMeta = (LocalMetadataEntry)this.localCache.getIfPresent((Object)parentPath);
                DirListingMetadata parentDirMeta = new DirListingMetadata(parentPath, DirListingMetadata.EMPTY_DIR, false);
                parentDirMeta.put(status);
                this.getDirListingMeta(parentPath);
                if (parentMeta == null) {
                    this.localCache.put((Object)parentPath, (Object)new LocalMetadataEntry(parentDirMeta));
                } else if (!parentMeta.hasDirMeta()) {
                    parentMeta.setDirListingMetadata(parentDirMeta);
                } else {
                    parentMeta.getDirListingMeta().put(status);
                }
            }
        }
    }

    @Override
    public synchronized void put(DirListingMetadata meta) throws IOException {
        LocalMetadataEntry entry;
        if (LOG.isDebugEnabled()) {
            LOG.debug("put dirMeta {}", (Object)meta.prettyPrint());
        }
        if ((entry = (LocalMetadataEntry)this.localCache.getIfPresent((Object)this.standardize(meta.getPath()))) == null) {
            this.localCache.put((Object)this.standardize(meta.getPath()), (Object)new LocalMetadataEntry(meta));
        } else {
            entry.setDirListingMetadata(meta);
        }
        this.put(meta.getListing());
    }

    @Override
    public synchronized void put(Collection<PathMetadata> metas) throws IOException {
        for (PathMetadata meta : metas) {
            this.put(meta);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void destroy() throws IOException {
        if (this.localCache != null) {
            this.localCache.invalidateAll();
        }
    }

    @Override
    public void prune(long modTime) throws IOException {
        this.prune(modTime, "");
    }

    @Override
    public synchronized void prune(long modTime, String keyPrefix) {
        this.localCache.asMap().entrySet().stream().filter(entry -> ((LocalMetadataEntry)entry.getValue()).hasPathMeta()).filter(entry -> this.expired(((LocalMetadataEntry)entry.getValue()).getFileMeta().getFileStatus(), modTime, keyPrefix)).forEach(entry -> this.localCache.invalidate(entry.getKey()));
        this.localCache.asMap().entrySet().stream().filter(entry -> ((LocalMetadataEntry)entry.getValue()).hasDirMeta()).forEach(entry -> {
            Path path = (Path)entry.getKey();
            DirListingMetadata metadata = ((LocalMetadataEntry)entry.getValue()).getDirListingMeta();
            Collection<PathMetadata> oldChildren = metadata.getListing();
            LinkedList<PathMetadata> newChildren = new LinkedList<PathMetadata>();
            for (PathMetadata child : oldChildren) {
                FileStatus status = child.getFileStatus();
                if (this.expired(status, modTime, keyPrefix)) continue;
                newChildren.add(child);
            }
            if (newChildren.size() != oldChildren.size()) {
                DirListingMetadata parent;
                DirListingMetadata dlm = new DirListingMetadata(path, newChildren, false);
                this.localCache.put((Object)path, (Object)new LocalMetadataEntry(dlm));
                if (!path.isRoot() && (parent = this.getDirListingMeta(path.getParent())) != null) {
                    parent.setAuthoritative(false);
                }
            }
        });
    }

    private boolean expired(FileStatus status, long expiry, String keyPrefix) {
        String bucket = status.getPath().toUri().getHost();
        String statusTranslatedPath = "";
        statusTranslatedPath = bucket != null && !bucket.isEmpty() ? PathMetadataDynamoDBTranslation.pathToParentKey(status.getPath()) : status.getPath().toUri().getPath();
        return status.getModificationTime() < expiry && !status.isDirectory() && statusTranslatedPath.startsWith(keyPrefix);
    }

    @VisibleForTesting
    static void deleteEntryByAncestor(Path ancestor, Cache<Path, LocalMetadataEntry> cache, boolean tombstone) {
        cache.asMap().entrySet().stream().filter(entry -> LocalMetadataStore.isAncestorOf(ancestor, (Path)entry.getKey())).forEach(entry -> {
            LocalMetadataEntry meta = (LocalMetadataEntry)entry.getValue();
            Path path = (Path)entry.getKey();
            if (meta.hasDirMeta()) {
                cache.invalidate((Object)path);
            } else if (tombstone && meta.hasPathMeta()) {
                meta.setPathMetadata(PathMetadata.tombstone(path));
            } else {
                cache.invalidate((Object)path);
            }
        });
    }

    private static boolean isAncestorOf(Path ancestor, Path f) {
        String aStr = ancestor.toString();
        if (!ancestor.isRoot()) {
            aStr = aStr + "/";
        }
        String fStr = f.toString();
        return fStr.startsWith(aStr);
    }

    private void deleteCacheEntries(Path path, boolean tombstone) {
        DirListingMetadata dir;
        Path parent;
        LocalMetadataEntry entry = (LocalMetadataEntry)this.localCache.getIfPresent((Object)path);
        if (entry == null) {
            LOG.warn("Delete: path {} is missing from cache.", (Object)path);
            return;
        }
        LOG.debug("delete file entry for {}", (Object)path);
        if (entry.hasPathMeta()) {
            if (tombstone) {
                PathMetadata pmd = PathMetadata.tombstone(path);
                entry.setPathMetadata(pmd);
            } else {
                entry.setPathMetadata(null);
            }
        }
        if (entry.hasDirMeta()) {
            LOG.debug("removing listing of {}", (Object)path);
            entry.setDirListingMetadata(null);
        }
        if (!entry.hasDirMeta() && !entry.hasPathMeta()) {
            this.localCache.invalidate((Object)entry);
        }
        if ((parent = path.getParent()) != null && (dir = this.getDirListingMeta(parent)) != null) {
            LOG.debug("removing parent's entry for {} ", (Object)path);
            if (tombstone) {
                dir.markDeleted(path);
            } else {
                dir.remove(path);
            }
        }
    }

    private Path standardize(Path p) {
        Preconditions.checkArgument((boolean)p.isAbsolute(), (Object)"Path must be absolute");
        URI uri = p.toUri();
        if (this.uriHost != null) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)uri.getHost()));
        }
        return p;
    }

    @Override
    public Map<String, String> getDiagnostics() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "local://metadata");
        map.put("uriHost", this.uriHost);
        map.put("description", "Local in-VM metadata store for testing");
        map.put("persist.authoritative.bit", Boolean.toString(true));
        return map;
    }

    @Override
    public void updateParameters(Map<String, String> parameters) throws IOException {
    }

    PathMetadata getFileMeta(Path p) {
        LocalMetadataEntry entry = (LocalMetadataEntry)this.localCache.getIfPresent((Object)p);
        if (entry != null && entry.hasPathMeta()) {
            return entry.getFileMeta();
        }
        return null;
    }

    DirListingMetadata getDirListingMeta(Path p) {
        LocalMetadataEntry entry = (LocalMetadataEntry)this.localCache.getIfPresent((Object)p);
        if (entry != null && entry.hasDirMeta()) {
            return entry.getDirListingMeta();
        }
        return null;
    }
}

