/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.typedbytes;

import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.record.Index;
import org.apache.hadoop.record.RecordInput;
import org.apache.hadoop.typedbytes.TypedBytesInput;

public class TypedBytesRecordInput
implements RecordInput {
    private TypedBytesInput in;
    private static final ThreadLocal<TypedBytesRecordInput> TB_IN = new ThreadLocal<TypedBytesRecordInput>(){

        @Override
        protected TypedBytesRecordInput initialValue() {
            return new TypedBytesRecordInput();
        }
    };

    private TypedBytesRecordInput() {
    }

    private void setTypedBytesInput(TypedBytesInput in) {
        this.in = in;
    }

    public static TypedBytesRecordInput get(TypedBytesInput in) {
        TypedBytesRecordInput bin = TB_IN.get();
        bin.setTypedBytesInput(in);
        return bin;
    }

    public static TypedBytesRecordInput get(DataInput in) {
        return TypedBytesRecordInput.get(TypedBytesInput.get(in));
    }

    public TypedBytesRecordInput(TypedBytesInput in) {
        this.in = in;
    }

    public TypedBytesRecordInput(DataInput in) {
        this(new TypedBytesInput(in));
    }

    @Override
    public boolean readBool(String tag) throws IOException {
        this.in.skipType();
        return this.in.readBool();
    }

    @Override
    public Buffer readBuffer(String tag) throws IOException {
        this.in.skipType();
        return new Buffer(this.in.readBytes());
    }

    @Override
    public byte readByte(String tag) throws IOException {
        this.in.skipType();
        return this.in.readByte();
    }

    @Override
    public double readDouble(String tag) throws IOException {
        this.in.skipType();
        return this.in.readDouble();
    }

    @Override
    public float readFloat(String tag) throws IOException {
        this.in.skipType();
        return this.in.readFloat();
    }

    @Override
    public int readInt(String tag) throws IOException {
        this.in.skipType();
        return this.in.readInt();
    }

    @Override
    public long readLong(String tag) throws IOException {
        this.in.skipType();
        return this.in.readLong();
    }

    @Override
    public String readString(String tag) throws IOException {
        this.in.skipType();
        return this.in.readString();
    }

    @Override
    public void startRecord(String tag) throws IOException {
        this.in.skipType();
    }

    @Override
    public Index startVector(String tag) throws IOException {
        this.in.skipType();
        return new TypedBytesIndex(this.in.readVectorHeader());
    }

    @Override
    public Index startMap(String tag) throws IOException {
        this.in.skipType();
        return new TypedBytesIndex(this.in.readMapHeader());
    }

    @Override
    public void endRecord(String tag) throws IOException {
    }

    @Override
    public void endVector(String tag) throws IOException {
    }

    @Override
    public void endMap(String tag) throws IOException {
    }

    private static final class TypedBytesIndex
    implements Index {
        private int nelems;

        private TypedBytesIndex(int nelems) {
            this.nelems = nelems;
        }

        @Override
        public boolean done() {
            return this.nelems <= 0;
        }

        @Override
        public void incr() {
            --this.nelems;
        }
    }
}

