/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.uam;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.AMRMClientUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.AMHeartbeatRequestHandler;
import org.apache.hadoop.yarn.server.AMRMClientRelayer;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.AsyncCallback;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class UnmanagedApplicationManager {
    private static final Logger LOG = LoggerFactory.getLogger(UnmanagedApplicationManager.class);
    private static final long AM_STATE_WAIT_TIMEOUT_MS = 10000L;
    public static final String APP_NAME = "UnmanagedAM";
    private static final String DEFAULT_QUEUE_CONFIG = "uam.default.queue.name";
    private AMHeartbeatRequestHandler heartbeatHandler;
    private AMRMClientRelayer rmProxyRelayer;
    private ApplicationId applicationId;
    private String submitter;
    private String appNameSuffix;
    private Configuration conf;
    private String queueName;
    private UserGroupInformation userUgi;
    private RegisterApplicationMasterRequest registerRequest;
    private ApplicationClientProtocol rmClient;
    private long asyncApiPollIntervalMillis;
    private RecordFactory recordFactory;
    private boolean keepContainersAcrossApplicationAttempts;
    private boolean connectionInitiated;

    public UnmanagedApplicationManager(Configuration conf, ApplicationId appId, String queueName, String submitter, String appNameSuffix, boolean keepContainersAcrossApplicationAttempts, String rmName) {
        Preconditions.checkNotNull((Object)conf, (Object)"Configuration cannot be null");
        Preconditions.checkNotNull((Object)appId, (Object)"ApplicationId cannot be null");
        Preconditions.checkNotNull((Object)submitter, (Object)"App submitter cannot be null");
        this.conf = conf;
        this.applicationId = appId;
        this.queueName = queueName;
        this.submitter = submitter;
        this.appNameSuffix = appNameSuffix;
        this.userUgi = null;
        this.rmProxyRelayer = new AMRMClientRelayer(null, this.applicationId, rmName);
        this.heartbeatHandler = this.createAMHeartbeatRequestHandler(this.conf, this.applicationId, this.rmProxyRelayer);
        this.connectionInitiated = false;
        this.registerRequest = null;
        this.recordFactory = RecordFactoryProvider.getRecordFactory((Configuration)conf);
        this.asyncApiPollIntervalMillis = conf.getLong("yarn.client.application-client-protocol.poll-interval-ms", 200L);
        this.keepContainersAcrossApplicationAttempts = keepContainersAcrossApplicationAttempts;
    }

    @VisibleForTesting
    protected AMHeartbeatRequestHandler createAMHeartbeatRequestHandler(Configuration config, ApplicationId appId, AMRMClientRelayer relayer) {
        return new AMHeartbeatRequestHandler(config, appId, relayer);
    }

    public Token<AMRMTokenIdentifier> launchUAM() throws YarnException, IOException {
        this.connectionInitiated = true;
        Token<AMRMTokenIdentifier> amrmToken = this.initializeUnmanagedAM(this.applicationId);
        this.createUAMProxy(amrmToken);
        return amrmToken;
    }

    public void reAttachUAM(Token<AMRMTokenIdentifier> amrmToken) throws IOException, YarnException {
        this.connectionInitiated = true;
        this.createUAMProxy(amrmToken);
    }

    protected void createUAMProxy(Token<AMRMTokenIdentifier> amrmToken) throws IOException {
        this.userUgi = UserGroupInformation.createProxyUser((String)this.applicationId.toString(), (UserGroupInformation)UserGroupInformation.getCurrentUser());
        this.rmProxyRelayer.setRMClient(this.createRMProxy(ApplicationMasterProtocol.class, this.conf, this.userUgi, amrmToken));
        this.heartbeatHandler.setUGI(this.userUgi);
    }

    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        this.registerRequest = request;
        LOG.info("Registering the Unmanaged application master {}", (Object)this.applicationId);
        RegisterApplicationMasterResponse response = this.rmProxyRelayer.registerApplicationMaster(this.registerRequest);
        this.heartbeatHandler.resetLastResponseId();
        for (Container container : response.getContainersFromPreviousAttempts()) {
            LOG.debug("RegisterUAM returned existing running container {}", (Object)container.getId());
        }
        for (NMToken nmToken : response.getNMTokensFromPreviousAttempts()) {
            LOG.debug("RegisterUAM returned existing NM token for node {}", (Object)nmToken.getNodeId());
        }
        LOG.info("RegisterUAM returned {} existing running container and {} NM tokens", (Object)response.getContainersFromPreviousAttempts().size(), (Object)response.getNMTokensFromPreviousAttempts().size());
        this.heartbeatHandler.setDaemon(true);
        this.heartbeatHandler.start();
        return response;
    }

    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        if (this.userUgi == null) {
            if (this.connectionInitiated) {
                LOG.warn("Unmanaged AM still not successfully launched/registered yet. Stopping the UAM heartbeat thread anyways.");
                return FinishApplicationMasterResponse.newInstance((boolean)false);
            }
            throw new YarnException("finishApplicationMaster should not be called before createAndRegister");
        }
        FinishApplicationMasterResponse response = this.rmProxyRelayer.finishApplicationMaster(request);
        if (response.getIsUnregistered()) {
            this.shutDownConnections();
        }
        return response;
    }

    public KillApplicationResponse forceKillApplication() throws IOException, YarnException {
        this.shutDownConnections();
        KillApplicationRequest request = KillApplicationRequest.newInstance((ApplicationId)this.applicationId);
        if (this.rmClient == null) {
            this.rmClient = this.createRMProxy(ApplicationClientProtocol.class, this.conf, UserGroupInformation.createRemoteUser((String)this.submitter), null);
        }
        return this.rmClient.forceKillApplication(request);
    }

    public void allocateAsync(AllocateRequest request, AsyncCallback<AllocateResponse> callback) throws YarnException {
        this.heartbeatHandler.allocateAsync(request, callback);
        if (this.userUgi == null) {
            if (this.connectionInitiated) {
                LOG.info("Unmanaged AM still not successfully launched/registered yet. Saving the allocate request and send later.");
            } else {
                throw new YarnException("AllocateAsync should not be called before launchUAM");
            }
        }
    }

    public void shutDownConnections() {
        this.heartbeatHandler.shutdown();
        this.rmProxyRelayer.shutdown();
    }

    public ApplicationId getAppId() {
        return this.applicationId;
    }

    public AMRMClientRelayer getAMRMClientRelayer() {
        return this.rmProxyRelayer;
    }

    protected <T> T createRMProxy(Class<T> protocol, Configuration config, UserGroupInformation user, Token<AMRMTokenIdentifier> token) throws IOException {
        return (T)AMRMClientUtils.createRMProxy((Configuration)config, protocol, (UserGroupInformation)user, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Token<AMRMTokenIdentifier> initializeUnmanagedAM(ApplicationId appId) throws IOException, YarnException {
        try {
            UserGroupInformation appSubmitter = UserGroupInformation.createRemoteUser((String)this.submitter);
            this.rmClient = this.createRMProxy(ApplicationClientProtocol.class, this.conf, appSubmitter, null);
            this.submitUnmanagedApp(appId);
            this.monitorCurrentAppAttempt(appId, EnumSet.of(YarnApplicationState.ACCEPTED, YarnApplicationState.RUNNING, YarnApplicationState.KILLED, YarnApplicationState.FAILED, YarnApplicationState.FINISHED), YarnApplicationAttemptState.LAUNCHED);
            Token<AMRMTokenIdentifier> token = this.getUAMToken();
            return token;
        }
        finally {
            this.rmClient = null;
        }
    }

    private void submitUnmanagedApp(ApplicationId appId) throws YarnException, IOException {
        SubmitApplicationRequest submitRequest = (SubmitApplicationRequest)this.recordFactory.newRecordInstance(SubmitApplicationRequest.class);
        ApplicationSubmissionContext context = (ApplicationSubmissionContext)this.recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        context.setApplicationId(appId);
        context.setApplicationName("UnmanagedAM-" + this.appNameSuffix);
        if (StringUtils.isBlank((CharSequence)this.queueName)) {
            context.setQueue(this.conf.get(DEFAULT_QUEUE_CONFIG, "default"));
        } else {
            context.setQueue(this.queueName);
        }
        ContainerLaunchContext amContainer = (ContainerLaunchContext)this.recordFactory.newRecordInstance(ContainerLaunchContext.class);
        Resource resource = BuilderUtils.newResource(1024L, 1);
        context.setResource(resource);
        context.setAMContainerSpec(amContainer);
        submitRequest.setApplicationSubmissionContext(context);
        context.setUnmanagedAM(true);
        context.setKeepContainersAcrossApplicationAttempts(this.keepContainersAcrossApplicationAttempts);
        LOG.info("Submitting unmanaged application {}", (Object)appId);
        this.rmClient.submitApplication(submitRequest);
    }

    private ApplicationAttemptReport monitorCurrentAppAttempt(ApplicationId appId, Set<YarnApplicationState> appStates, YarnApplicationAttemptState attemptState) throws YarnException, IOException {
        long startTime = System.currentTimeMillis();
        ApplicationAttemptId appAttemptId = null;
        do {
            if (appAttemptId == null) {
                ApplicationReport report = this.getApplicationReport(appId);
                YarnApplicationState state = report.getYarnApplicationState();
                if (appStates.contains(state)) {
                    if (state != YarnApplicationState.ACCEPTED) {
                        throw new YarnRuntimeException("Received non-accepted application state: " + state + " for " + appId + ". This is likely because this is not the first app attempt in home sub-cluster, and AMRMProxy HA (yarn.nodemanager.amrmproxy.ha.enable) is not enabled.");
                    }
                    appAttemptId = this.getApplicationReport(appId).getCurrentApplicationAttemptId();
                } else {
                    LOG.info("Current application state of {} is {}, will retry later.", (Object)appId, (Object)state);
                }
            }
            if (appAttemptId != null) {
                GetApplicationAttemptReportRequest req = (GetApplicationAttemptReportRequest)this.recordFactory.newRecordInstance(GetApplicationAttemptReportRequest.class);
                req.setApplicationAttemptId(appAttemptId);
                ApplicationAttemptReport attemptReport = this.rmClient.getApplicationAttemptReport(req).getApplicationAttemptReport();
                if (attemptState.equals((Object)attemptReport.getYarnApplicationAttemptState())) {
                    return attemptReport;
                }
                LOG.info("Current attempt state of " + appAttemptId + " is " + attemptReport.getYarnApplicationAttemptState() + ", waiting for current attempt to reach " + attemptState);
            }
            try {
                Thread.sleep(this.asyncApiPollIntervalMillis);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for current attempt of " + appId + " to reach " + attemptState);
            }
        } while (System.currentTimeMillis() - startTime <= 10000L);
        throw new RuntimeException("Timeout for waiting current attempt of " + appId + " to reach " + attemptState);
    }

    protected Token<AMRMTokenIdentifier> getUAMToken() throws IOException, YarnException {
        Token token = null;
        org.apache.hadoop.yarn.api.records.Token amrmToken = this.getApplicationReport(this.applicationId).getAMRMToken();
        if (amrmToken != null) {
            token = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)amrmToken, (Text)null);
        } else {
            LOG.warn("AMRMToken not found in the application report for application: {}", (Object)this.applicationId);
        }
        return token;
    }

    private ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        GetApplicationReportRequest request = (GetApplicationReportRequest)this.recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        request.setApplicationId(appId);
        return this.rmClient.getApplicationReport(request).getApplicationReport();
    }

    @VisibleForTesting
    public int getRequestQueueSize() {
        return this.heartbeatHandler.getRequestQueueSize();
    }

    @VisibleForTesting
    protected void drainHeartbeatThread() {
        this.heartbeatHandler.drainHeartbeatThread();
    }

    @VisibleForTesting
    protected boolean isHeartbeatThreadAlive() {
        return this.heartbeatHandler.isAlive();
    }
}

