/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionAdapter;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
public class ConnectionUtils {
    private static final Random RANDOM = new Random();

    public static long getPauseTime(long pause, int tries) {
        int ntries = tries;
        if (ntries >= HConstants.RETRY_BACKOFF.length) {
            ntries = HConstants.RETRY_BACKOFF.length - 1;
        }
        long normalPause = pause * (long)HConstants.RETRY_BACKOFF[ntries];
        long jitter = (long)((float)normalPause * RANDOM.nextFloat() * 0.01f);
        return normalPause + jitter;
    }

    public static long addJitter(long pause, float jitter) {
        float lag = (float)pause * (RANDOM.nextFloat() - 0.5f) * jitter;
        long newPause = pause + (long)lag;
        if (newPause <= 0L) {
            return 1L;
        }
        return newPause;
    }

    public static NonceGenerator injectNonceGeneratorForTesting(ClusterConnection conn, NonceGenerator cnm) {
        return ConnectionManager.injectNonceGeneratorForTesting(conn, cnm);
    }

    public static void setServerSideHConnectionRetriesConfig(Configuration c, String sn, Log log) {
        int hcRetries = c.getInt("hbase.client.retries.number", 31);
        int serversideMultiplier = c.getInt("hbase.client.serverside.retries.multiplier", 10);
        int retries = hcRetries * serversideMultiplier;
        c.setInt("hbase.client.retries.number", retries);
        log.info((Object)(sn + " server-side HConnection retries=" + retries));
    }

    @Deprecated
    public static ClusterConnection createShortCircuitHConnection(Connection conn, final ServerName serverName, final AdminProtos.AdminService.BlockingInterface admin, final ClientProtos.ClientService.BlockingInterface client) {
        return new ConnectionAdapter(conn){

            @Override
            public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName sn, boolean getMaster) throws IOException {
                return serverName.equals(sn) ? admin : super.getAdmin(sn, getMaster);
            }

            @Override
            public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
                return serverName.equals(sn) ? client : super.getClient(sn);
            }
        };
    }

    public static ClusterConnection createShortCircuitConnection(Configuration conf, ExecutorService pool, User user, final ServerName serverName, final AdminProtos.AdminService.BlockingInterface admin, final ClientProtos.ClientService.BlockingInterface client) throws IOException {
        if (user == null) {
            user = UserProvider.instantiate(conf).getCurrent();
        }
        return new ConnectionManager.HConnectionImplementation(conf, false, pool, user){

            @Override
            public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName sn, boolean getMaster) throws IOException {
                return serverName.equals(sn) ? admin : super.getAdmin(sn, getMaster);
            }

            @Override
            public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
                return serverName.equals(sn) ? client : super.getClient(sn);
            }
        };
    }

    @VisibleForTesting
    public static void setupMasterlessConnection(Configuration conf) {
        conf.set("hbase.client.connection.impl", MasterlessConnection.class.getName());
    }

    static class MasterlessConnection
    extends ConnectionManager.HConnectionImplementation {
        MasterlessConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
            super(conf, managed, pool, user);
        }

        @Override
        public boolean isTableDisabled(TableName tableName) throws IOException {
            return false;
        }
    }
}

