/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.beanutils;

import org.apache.hadoop.hbase.shaded.org.apache.commons.beanutils.DynaBean;
import org.apache.hadoop.hbase.shaded.org.apache.commons.beanutils.DynaClass;
import org.apache.hadoop.hbase.shaded.org.apache.commons.beanutils.DynaProperty;
import org.apache.hadoop.hbase.shaded.org.apache.commons.beanutils.PropertyUtils;
import org.apache.hadoop.hbase.shaded.org.apache.commons.beanutils.WrapDynaClass;

public class WrapDynaBean
implements DynaBean {
    protected WrapDynaClass dynaClass = null;
    protected Object instance = null;

    public WrapDynaBean(Object instance) {
        this.instance = instance;
        this.dynaClass = WrapDynaClass.createDynaClass(instance.getClass());
    }

    public boolean contains(String name, String key) {
        throw new UnsupportedOperationException("WrapDynaBean does not support contains()");
    }

    public Object get(String name) {
        Object value = null;
        try {
            value = PropertyUtils.getSimpleProperty(this.instance, name);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Property '" + name + "' has no read method");
        }
        return value;
    }

    public Object get(String name, int index) {
        Object value = null;
        try {
            value = PropertyUtils.getIndexedProperty(this.instance, name, index);
        }
        catch (IndexOutOfBoundsException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Property '" + name + "' has no indexed read method");
        }
        return value;
    }

    public Object get(String name, String key) {
        Object value = null;
        try {
            value = PropertyUtils.getMappedProperty(this.instance, name, key);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Property '" + name + "' has no mapped read method");
        }
        return value;
    }

    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    public void remove(String name, String key) {
        throw new UnsupportedOperationException("WrapDynaBean does not support remove()");
    }

    public void set(String name, Object value) {
        try {
            PropertyUtils.setSimpleProperty(this.instance, name, value);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Property '" + name + "' has no write method");
        }
    }

    public void set(String name, int index, Object value) {
        try {
            PropertyUtils.setIndexedProperty(this.instance, name, index, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Property '" + name + "' has no indexed write method");
        }
    }

    public void set(String name, String key, Object value) {
        try {
            PropertyUtils.setMappedProperty(this.instance, name, key, value);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Property '" + name + "' has no mapped write method");
        }
    }

    public Object getInstance() {
        return this.instance;
    }

    protected DynaProperty getDynaProperty(String name) {
        DynaProperty descriptor = this.getDynaClass().getDynaProperty(name);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid property name '" + name + "'");
        }
        return descriptor;
    }
}

