/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Set;
import org.apache.heron.api.grouping.StreamGrouping;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.IStreamletBasicOperator;
import org.apache.heron.streamlet.IStreamletOperator;
import org.apache.heron.streamlet.IStreamletRichOperator;
import org.apache.heron.streamlet.IStreamletWindowOperator;
import org.apache.heron.streamlet.impl.StreamletImpl;

public class CustomStreamlet<R, T>
extends StreamletImpl<T> {
    private StreamletImpl<R> parent;
    private IStreamletOperator<R, T> operator;
    private StreamGrouping grouper;

    public CustomStreamlet(StreamletImpl<R> parent, IStreamletOperator<R, T> operator, StreamGrouping grouper) {
        this.parent = parent;
        this.operator = operator;
        this.grouper = grouper;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        if (this.operator instanceof IStreamletBasicOperator) {
            this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.CUSTOM, stageNames);
            IStreamletBasicOperator op = (IStreamletBasicOperator)this.operator;
            bldr.setBolt(this.getName(), op, (Number)this.getNumPartitions()).grouping(this.parent.getName(), this.parent.getStreamId(), this.grouper);
        } else if (this.operator instanceof IStreamletRichOperator) {
            this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.CUSTOM_BASIC, stageNames);
            IStreamletRichOperator op = (IStreamletRichOperator)this.operator;
            bldr.setBolt(this.getName(), op, (Number)this.getNumPartitions()).grouping(this.parent.getName(), this.parent.getStreamId(), this.grouper);
        } else if (this.operator instanceof IStreamletWindowOperator) {
            this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.CUSTOM_WINDOW, stageNames);
            IStreamletWindowOperator op = (IStreamletWindowOperator)this.operator;
            bldr.setBolt(this.getName(), op, (Number)this.getNumPartitions()).grouping(this.parent.getName(), this.parent.getStreamId(), this.grouper);
        } else {
            throw new RuntimeException("Unhandled operator class is found!");
        }
        return true;
    }
}

