/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api.windowing.evictors;

import java.io.Serializable;
import org.apache.heron.api.windowing.Event;
import org.apache.heron.api.windowing.EvictionPolicy;
import org.apache.heron.api.windowing.evictors.TimeEvictionPolicy;

public class WatermarkTimeEvictionPolicy<T extends Serializable>
extends TimeEvictionPolicy<T> {
    private final long lag;

    public WatermarkTimeEvictionPolicy(long windowLength) {
        this(windowLength, Long.MAX_VALUE);
    }

    public WatermarkTimeEvictionPolicy(long windowLength, long lag) {
        super(windowLength);
        this.lag = lag;
    }

    @Override
    public EvictionPolicy.Action evict(Event<T> event) {
        if (this.evictionContext == null) {
            return EvictionPolicy.Action.STOP;
        }
        long referenceTime = this.evictionContext.getReferenceTime();
        long diff = referenceTime - event.getTimestamp();
        if (diff < -this.lag) {
            return EvictionPolicy.Action.STOP;
        }
        if (diff < 0L) {
            return EvictionPolicy.Action.KEEP;
        }
        return super.evict(event);
    }

    @Override
    public String toString() {
        return "WatermarkTimeEvictionPolicy{lag=" + this.lag + "} " + super.toString();
    }
}

