/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api.windowing.triggers;

import java.io.Serializable;
import java.time.Duration;
import org.apache.heron.api.Config;
import org.apache.heron.api.windowing.DefaultEvictionContext;
import org.apache.heron.api.windowing.Event;
import org.apache.heron.api.windowing.triggers.AbstractBaseTriggerPolicy;

public class TimeTriggerPolicy<T extends Serializable>
extends AbstractBaseTriggerPolicy<T, Void> {
    private long duration;

    public TimeTriggerPolicy(long millis) {
        this.duration = millis;
    }

    @Override
    public void track(Event<T> event) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
        super.start();
        Config.registerTopologyTimerEvents(this.topoConf, "TimeTriggerPolicyTimer", Duration.ofMillis(this.duration), () -> this.triggerTask());
    }

    @Override
    public void shutdown() {
    }

    public String toString() {
        return "TimeTriggerPolicy{duration=" + this.duration + '}';
    }

    private void triggerTask() {
        long now = System.currentTimeMillis() - 1L;
        this.evictionPolicy.setContext(new DefaultEvictionContext(now, null, null, this.duration));
        this.handler.onTrigger();
    }

    @Override
    public Void getState() {
        return null;
    }

    @Override
    public void restoreState(Void state) {
    }
}

