/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api.windowing.triggers;

import java.io.Serializable;
import java.util.List;
import org.apache.heron.api.windowing.DefaultEvictionContext;
import org.apache.heron.api.windowing.Event;
import org.apache.heron.api.windowing.triggers.AbstractBaseTriggerPolicy;

public class WatermarkCountTriggerPolicy<T extends Serializable>
extends AbstractBaseTriggerPolicy<T, Long> {
    private final int count;
    private volatile long lastProcessedTs;

    public WatermarkCountTriggerPolicy(int count) {
        this.count = count;
    }

    @Override
    public void track(Event<T> event) {
        if (this.started.booleanValue() && event.isWatermark()) {
            this.handleWaterMarkEvent(event);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown() {
    }

    private void handleWaterMarkEvent(Event<T> waterMarkEvent) {
        long watermarkTs = waterMarkEvent.getTimestamp();
        List<Long> eventTs = this.windowManager.getSlidingCountTimestamps(this.lastProcessedTs, watermarkTs, this.count);
        for (long ts : eventTs) {
            this.evictionPolicy.setContext(new DefaultEvictionContext(ts, null, Long.valueOf(this.count)));
            this.handler.onTrigger();
            this.lastProcessedTs = ts;
        }
    }

    @Override
    public Long getState() {
        return this.lastProcessedTs;
    }

    @Override
    public void restoreState(Long state) {
        this.lastProcessedTs = state;
    }

    public String toString() {
        return "WatermarkCountTriggerPolicy{count=" + this.count + ", lastProcessedTs=" + this.lastProcessedTs + ", started=" + this.started + '}';
    }
}

