/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.basics;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import org.apache.heron.common.basics.ByteAmount;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Integer getInteger(Object o) {
        if (o instanceof Long) {
            return ((Long)o).intValue();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Short) {
            return ((Short)o).intValue();
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Don't know how to convert " + o + " to int");
        }
    }

    public static Long getLong(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        if (o instanceof Short) {
            return ((Short)o).longValue();
        }
        try {
            return Long.parseLong(o.toString());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Don't know how to convert " + o + " to long");
        }
    }

    public static Double getDouble(Object o) {
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        if (o instanceof Long) {
            return ((Long)o).doubleValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Short) {
            return ((Short)o).doubleValue();
        }
        try {
            return Double.parseDouble(o.toString());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Failed to convert " + o + " to double");
        }
    }

    public static Duration getDuration(Object o, TemporalUnit unit) {
        if (o != null && o instanceof Duration) {
            return (Duration)o;
        }
        try {
            return Duration.of(TypeUtils.getLong(o), unit);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Don't know how to convert " + o + " to Duration", e);
        }
    }

    public static ByteAmount getByteAmount(Object o) {
        if (o != null && o instanceof ByteAmount) {
            return (ByteAmount)o;
        }
        try {
            return ByteAmount.fromBytes(TypeUtils.getLong(o));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Don't know how to convert " + o + " to ByteAmount", e);
        }
    }

    public static Boolean getBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        throw new IllegalArgumentException("Failed to convert " + o + " to boolean");
    }

    public static URI getURI(String spec) {
        try {
            return new URI(spec);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Don't know how to convert " + spec + " to URI");
        }
    }

    public static List<String> getListOfStrings(Object o) {
        if (o == null) {
            return new ArrayList<String>();
        }
        if (o instanceof List) {
            return (List)o;
        }
        throw new IllegalArgumentException("Failed to convert " + o + " to List<String>");
    }
}

