/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.sources;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.heron.api.spout.SpoutOutputCollector;
import org.apache.heron.api.state.State;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.tuple.Values;
import org.apache.heron.streamlet.Source;
import org.apache.heron.streamlet.impl.ContextImpl;
import org.apache.heron.streamlet.impl.sources.StreamletSource;

public class ComplexSource<R>
extends StreamletSource {
    private static final long serialVersionUID = -5086763670301450007L;
    private Source<R> generator;
    private State<Serializable, Serializable> state;

    public ComplexSource(Source<R> generator) {
        this.generator = generator;
    }

    @Override
    public void initState(State<Serializable, Serializable> startupState) {
        this.state = startupState;
    }

    @Override
    public void open(Map<String, Object> map, TopologyContext topologyContext, SpoutOutputCollector outputCollector) {
        super.open(map, topologyContext, outputCollector);
        ContextImpl context = new ContextImpl(topologyContext, map, this.state);
        this.generator.setup(context);
    }

    @Override
    public void nextTuple() {
        Collection<R> tuples = this.generator.get();
        if (tuples != null) {
            tuples.forEach(tuple -> this.collector.emit(new Values(tuple)));
        }
    }
}

