/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.List;
import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.SerializableBiFunction;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.groupings.RemapCustomGrouping;
import org.apache.heron.streamlet.impl.operators.MapOperator;

public class RemapStreamlet<R>
extends StreamletImpl<R> {
    private StreamletImpl<R> parent;
    private SerializableBiFunction<? super R, Integer, List<Integer>> remapFn;

    public RemapStreamlet(StreamletImpl<R> parent, SerializableBiFunction<? super R, Integer, List<Integer>> remapFn) {
        this.parent = parent;
        this.remapFn = remapFn;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.REMAP, stageNames);
        bldr.setBolt(this.getName(), new MapOperator(a -> a), (Number)this.getNumPartitions()).customGrouping(this.parent.getName(), this.parent.getStreamId(), new RemapCustomGrouping<R>(this.remapFn));
        return true;
    }
}

