/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api.metric;

import java.util.HashMap;
import java.util.Map;
import org.apache.heron.api.metric.AssignableMetric;
import org.apache.heron.api.metric.IMetric;

public class MultiAssignableMetric<T extends Number>
implements IMetric<Map<String, T>> {
    private final Map<String, AssignableMetric<T>> value = new HashMap<String, AssignableMetric<T>>();
    private T initialValue;

    public MultiAssignableMetric(T initialValue) {
        this.initialValue = initialValue;
    }

    public AssignableMetric<T> scope(String key) {
        AssignableMetric<T> val = this.value.get(key);
        if (val == null) {
            val = new AssignableMetric<T>(this.initialValue);
            this.value.put(key, val);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssignableMetric<T> safeScope(String key) {
        AssignableMetric<T> val;
        Map<String, AssignableMetric<T>> map = this.value;
        synchronized (map) {
            val = this.value.get(key);
            if (val == null) {
                val = new AssignableMetric<T>(this.initialValue);
                this.value.put(key, val);
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, T> getValueAndReset() {
        HashMap<String, Number> ret = new HashMap<String, Number>();
        Map<String, AssignableMetric<T>> map = this.value;
        synchronized (map) {
            for (Map.Entry<String, AssignableMetric<T>> e : this.value.entrySet()) {
                ret.put(e.getKey(), (Number)e.getValue().getValueAndReset());
            }
        }
        return ret;
    }
}

