/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api.topology;

import java.util.Map;
import org.apache.heron.api.Config;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.topology.BaseConfigurationDeclarer;
import org.apache.heron.api.topology.ComponentConfigurationDeclarer;
import org.apache.heron.api.topology.IComponent;
import org.apache.heron.api.utils.Utils;
import org.apache.heron.shaded.com.google.protobuf.ByteString;

public abstract class BaseComponentDeclarer<T extends ComponentConfigurationDeclarer<?>>
extends BaseConfigurationDeclarer<T> {
    private String name;
    private IComponent component;
    private Config componentConfiguration;

    public BaseComponentDeclarer(String name, IComponent comp, Number taskParallelism) {
        this.name = name;
        this.component = comp;
        this.componentConfiguration = comp.getComponentConfiguration() != null ? new Config(comp.getComponentConfiguration()) : new Config();
        if (taskParallelism != null) {
            Config.setComponentParallelism(this.componentConfiguration, taskParallelism.intValue());
        } else {
            Config.setComponentParallelism(this.componentConfiguration, 1);
        }
    }

    public abstract T returnThis();

    protected String getName() {
        return this.name;
    }

    @Override
    public T addConfigurations(Map<String, Object> conf) {
        this.componentConfiguration.putAll(conf);
        return this.returnThis();
    }

    public void dump(TopologyAPI.Component.Builder bldr) {
        bldr.setName(this.name);
        bldr.setSpec(TopologyAPI.ComponentObjectSpec.JAVA_SERIALIZED_OBJECT);
        bldr.setSerializedObject(ByteString.copyFrom(Utils.serialize(this.component)));
        bldr.setConfig(Utils.getConfigBuilder(this.componentConfiguration));
    }
}

