/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.basics;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

public abstract class WakeableLooper {
    private final List<Runnable> tasksOnWakeup = new ArrayList<Runnable>();
    private final PriorityQueue<TimerTask> timers = new PriorityQueue();
    private final List<Runnable> exitTasks = new ArrayList<Runnable>();
    private static final Duration INFINITE_FUTURE = Duration.ofMillis(Integer.MAX_VALUE);
    private volatile boolean exitLoop = false;
    private boolean terminateAllTasksOnWakeup = false;
    private boolean terminateAllExitTasks = false;

    public void clear() {
        this.clearTasksOnWakeup();
        this.clearTimers();
        this.clearExitTasks();
    }

    public void clearTasksOnWakeup() {
        this.tasksOnWakeup.clear();
        this.terminateAllTasksOnWakeup = true;
    }

    public void clearTimers() {
        this.timers.clear();
    }

    public void clearExitTasks() {
        this.exitTasks.clear();
        this.terminateAllExitTasks = true;
    }

    public void loop() {
        while (!this.exitLoop) {
            this.runOnce();
        }
        this.onExit();
    }

    private void runOnce() {
        this.doWait();
        this.executeTasksOnWakeup();
        this.triggerExpiredTimers(System.nanoTime());
    }

    private void onExit() {
        int s = this.exitTasks.size();
        for (int i = 0; i < s && !this.terminateAllExitTasks; ++i) {
            this.exitTasks.get(i).run();
        }
        this.terminateAllExitTasks = false;
    }

    protected abstract void doWait();

    public abstract void wakeUp();

    public void addTasksOnWakeup(Runnable task) {
        this.tasksOnWakeup.add(task);
        this.wakeUp();
    }

    public void addTasksOnExit(Runnable task) {
        this.exitTasks.add(task);
    }

    public void registerTimerEvent(Duration timerDuration, Runnable task) {
        assert (timerDuration.getSeconds() >= 0L);
        assert (task != null);
        Duration expiration = timerDuration.plusNanos(System.nanoTime());
        this.timers.add(new TimerTask(expiration, task));
    }

    public void registerPeriodicEvent(final Duration frequency, final Runnable task) {
        this.registerTimerEvent(frequency, new Runnable(){

            @Override
            public void run() {
                task.run();
                WakeableLooper.this.registerPeriodicEvent(frequency, task);
            }
        });
    }

    public void exitLoop() {
        this.exitLoop = true;
        this.wakeUp();
    }

    protected Duration getNextTimeoutInterval() {
        Duration nextTimeoutInterval = INFINITE_FUTURE;
        if (!this.timers.isEmpty()) {
            nextTimeoutInterval = this.timers.peek().expirationTime.minusNanos(System.nanoTime());
        }
        return nextTimeoutInterval;
    }

    private void executeTasksOnWakeup() {
        int s = this.tasksOnWakeup.size();
        for (int i = 0; i < s && !this.terminateAllTasksOnWakeup; ++i) {
            this.tasksOnWakeup.get(i).run();
        }
        this.terminateAllTasksOnWakeup = false;
    }

    private void triggerExpiredTimers(long currentTime) {
        while (!this.timers.isEmpty()) {
            long nextExpiredTime = this.timers.peek().expirationTime.toNanos();
            if (nextExpiredTime - currentTime <= 0L) {
                this.timers.poll().handler.run();
                continue;
            }
            return;
        }
    }

    private static class TimerTask
    implements Comparable<TimerTask> {
        private final Duration expirationTime;
        private final Runnable handler;

        TimerTask(Duration expirationTime, Runnable handler) {
            this.expirationTime = expirationTime;
            this.handler = handler;
        }

        @Override
        public int compareTo(TimerTask other) {
            return this.expirationTime.compareTo(other.expirationTime);
        }

        public boolean equals(Object other) {
            throw new RuntimeException("TODO: implement");
        }

        public int hashCode() {
            throw new RuntimeException("TODO: implement");
        }
    }
}

