/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.groupings;

import java.util.ArrayList;
import java.util.List;
import org.apache.heron.api.grouping.CustomStreamGrouping;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.utils.Utils;
import org.apache.heron.streamlet.SerializableBiFunction;

public class RemapCustomGrouping<R>
implements CustomStreamGrouping {
    private static final long serialVersionUID = 8118844912340601079L;
    private List<Integer> taskIds;
    private SerializableBiFunction<? super R, Integer, List<Integer>> remapFn;

    public RemapCustomGrouping(SerializableBiFunction<? super R, Integer, List<Integer>> remapFn) {
        this.remapFn = remapFn;
    }

    @Override
    public void prepare(TopologyContext context, String component, String streamId, List<Integer> targetTasks) {
        this.taskIds = targetTasks;
    }

    @Override
    public List<Integer> chooseTasks(List<Object> values) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        Object obj = values.get(0);
        List targets = (List)this.remapFn.apply(obj, this.taskIds.size());
        for (Integer target : targets) {
            ret.add(Utils.assignKeyToTask(target, this.taskIds));
        }
        return ret;
    }
}

