/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.operators;

import org.apache.heron.api.tuple.Tuple;
import org.apache.heron.api.tuple.Values;
import org.apache.heron.streamlet.KeyValue;
import org.apache.heron.streamlet.SerializableFunction;
import org.apache.heron.streamlet.impl.operators.StreamletOperator;

public class KeyByOperator<R, K, V>
extends StreamletOperator<R, KeyValue<K, V>> {
    private SerializableFunction<R, K> keyExtractor;
    private SerializableFunction<R, V> valueExtractor;

    public KeyByOperator(SerializableFunction<R, K> keyExtractor, SerializableFunction<R, V> valueExtractor) {
        this.keyExtractor = keyExtractor;
        this.valueExtractor = valueExtractor;
    }

    @Override
    public void execute(Tuple tuple) {
        Object obj = tuple.getValue(0);
        Object key = this.keyExtractor.apply(obj);
        Object value = this.valueExtractor.apply(obj);
        this.collector.emit(new Values(new KeyValue(key, value)));
        this.collector.ack(tuple);
    }
}

