/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.SerializableFunction;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.operators.FlatMapOperator;

public class FlatMapStreamlet<R, T>
extends StreamletImpl<T> {
    private StreamletImpl<R> parent;
    private SerializableFunction<? super R, ? extends Iterable<? extends T>> flatMapFn;

    public FlatMapStreamlet(StreamletImpl<R> parent, SerializableFunction<? super R, ? extends Iterable<? extends T>> flatMapFn) {
        this.parent = parent;
        this.flatMapFn = flatMapFn;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.FLATMAP, stageNames);
        bldr.setBolt(this.getName(), new FlatMapOperator(this.flatMapFn), (Number)this.getNumPartitions()).shuffleGrouping(this.parent.getName(), this.parent.getStreamId());
        return true;
    }
}

