/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.KeyValue;
import org.apache.heron.streamlet.SerializableFunction;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.operators.KeyByOperator;

public class KeyByStreamlet<R, K, V>
extends StreamletImpl<KeyValue<K, V>> {
    private StreamletImpl<R> parent;
    private SerializableFunction<R, K> keyExtractor;
    private SerializableFunction<R, V> valueExtractor;

    public KeyByStreamlet(StreamletImpl<R> parent, SerializableFunction<R, K> keyExtractor, SerializableFunction<R, V> valueExtractor) {
        this.parent = parent;
        this.keyExtractor = keyExtractor;
        this.valueExtractor = valueExtractor;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.KEYBY, stageNames);
        KeyByOperator<R, K, V> bolt = new KeyByOperator<R, K, V>(this.keyExtractor, this.valueExtractor);
        bldr.setBolt(this.getName(), bolt, (Number)this.getNumPartitions()).shuffleGrouping(this.parent.getName(), this.parent.getStreamId());
        return true;
    }
}

