/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.binarysortable;

import java.util.Objects;
import java.util.Properties;

public final class BinarySortableUtils {
    public static void fillOrderArrays(Properties inputProperties, boolean[] columnSortOrderIsDesc, byte[] columnNullMarker, byte[] columnNotNullMarker) {
        String columnNullOrder;
        Objects.requireNonNull(inputProperties, "inputProperties can not be null");
        Objects.requireNonNull(columnSortOrderIsDesc, "columnSortOrderIsDesc can not be null");
        Objects.requireNonNull(columnNullMarker, "columnNullMarker can not be null");
        Objects.requireNonNull(columnNotNullMarker, "columnNotNullMarker can not be null");
        if (columnSortOrderIsDesc.length != columnNullMarker.length || columnSortOrderIsDesc.length != columnNotNullMarker.length) {
            throw new IllegalArgumentException("columnSortOrderIsDesc, columnNullMarker and columnNotNullMarker arrays should have same length.");
        }
        String columnSortOrder = inputProperties.getProperty("serialization.sort.order");
        if (columnSortOrder != null) {
            if (columnSortOrder.length() < columnSortOrderIsDesc.length) {
                throw new ArrayIndexOutOfBoundsException(String.format("From %d columns only %d has sort order specified.", columnSortOrderIsDesc.length, columnSortOrder.length()));
            }
            for (int i = 0; i < columnSortOrderIsDesc.length; ++i) {
                columnSortOrderIsDesc[i] = columnSortOrder.charAt(i) == '-';
            }
        }
        if ((columnNullOrder = inputProperties.getProperty("serialization.sort.order.null")) != null && columnNullOrder.length() < columnNullMarker.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("From %d columns only %d has null sort order specified.", columnNullMarker.length, columnNullOrder.length()));
        }
        for (int i = 0; i < columnSortOrderIsDesc.length; ++i) {
            if (columnSortOrderIsDesc[i]) {
                if (columnNullOrder != null && columnNullOrder.charAt(i) == 'a') {
                    columnNullMarker[i] = 1;
                    columnNotNullMarker[i] = 0;
                    continue;
                }
                columnNullMarker[i] = 0;
                columnNotNullMarker[i] = 1;
                continue;
            }
            if (columnNullOrder != null && columnNullOrder.charAt(i) == 'z') {
                columnNullMarker[i] = 1;
                columnNotNullMarker[i] = 0;
                continue;
            }
            columnNullMarker[i] = 0;
            columnNotNullMarker[i] = 1;
        }
    }

    private BinarySortableUtils() {
    }
}

