/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.viewer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.htrace.viewer.HBaseSpanViewerSpansServlet;
import org.apache.htrace.viewer.HBaseSpanViewerTracesServlet;

public class HBaseSpanViewerServer
implements Tool {
    private static final Log LOG = LogFactory.getLog(HBaseSpanViewerServer.class);
    public static final String HTRACE_VIEWER_HTTP_ADDRESS_KEY = "htrace.viewer.http.address";
    public static final String HTRACE_VIEWER_HTTP_ADDRESS_DEFAULT = "0.0.0.0:16900";
    public static final String HTRACE_CONF_ATTR = "htrace.conf";
    public static final String HTRACE_APPDIR = "webapps";
    public static final String NAME = "htrace";
    private Configuration conf;
    private HttpServer2 httpServer;
    private InetSocketAddress httpAddress;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    void start() throws IOException {
        this.httpAddress = NetUtils.createSocketAddr((String)this.conf.get(HTRACE_VIEWER_HTTP_ADDRESS_KEY, HTRACE_VIEWER_HTTP_ADDRESS_DEFAULT));
        this.conf.set(HTRACE_VIEWER_HTTP_ADDRESS_KEY, NetUtils.getHostPortString((InetSocketAddress)this.httpAddress));
        HttpServer2.Builder builder = new HttpServer2.Builder();
        builder.setName(NAME).setConf(this.conf);
        if (this.httpAddress.getPort() == 0) {
            builder.setFindPort(true);
        }
        URI uri = URI.create("http://" + NetUtils.getHostPortString((InetSocketAddress)this.httpAddress));
        builder.addEndpoint(uri);
        LOG.info((Object)("Starting Web-server for htrace at: " + uri));
        this.httpServer = builder.build();
        this.httpServer.setAttribute(HTRACE_CONF_ATTR, (Object)this.conf);
        this.httpServer.addServlet("gettraces", "/gettraces", HBaseSpanViewerTracesServlet.class);
        this.httpServer.addServlet("getspans", "/getspans/*", HBaseSpanViewerSpansServlet.class);
        String rb = this.httpServer.getClass().getClassLoader().getResource("webapps/htrace").toString();
        this.httpServer.getWebAppContext().setResourceBase(rb);
        this.httpServer.start();
        this.httpAddress = this.httpServer.getConnectorAddress(0);
    }

    void join() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.join();
        }
    }

    void stop() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
    }

    InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    public int run(String[] args) throws Exception {
        this.start();
        this.join();
        this.stop();
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new HBaseSpanViewerServer(), (String[])args);
    }
}

