/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FutureHttpResponse
implements Future<HttpResponse>,
FutureCallback<HttpResponse> {
    private final FutureCallback<HttpResponse> callback;
    private Future<HttpResponse> delegate;
    private HttpResponse response;
    private Throwable thrown;

    public FutureHttpResponse(FutureCallback<HttpResponse> callback) {
        this.callback = callback;
    }

    public String toString() {
        return String.valueOf(this.response);
    }

    public synchronized Future<HttpResponse> getDelegate() {
        return this.delegate;
    }

    public synchronized void setDelegate(Future<HttpResponse> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isCancelled() {
        Future<HttpResponse> delegate = this.getDelegate();
        return delegate != null && delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        Future<HttpResponse> delegate = this.getDelegate();
        return delegate != null && this.getDelegate().isDone();
    }

    @Override
    public HttpResponse get() throws InterruptedException, ExecutionException {
        try {
            this.getDelegate().get();
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        HttpResponse result = this.getResponse();
        Throwable thrown = this.getThrown();
        if (thrown != null) {
            throw new ExecutionException(thrown);
        }
        return result;
    }

    @Override
    public HttpResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this.getDelegate().get(timeout, unit);
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        HttpResponse result = this.getResponse();
        Throwable thrown = this.getThrown();
        if (thrown != null) {
            throw new ExecutionException(thrown);
        }
        return result;
    }

    public void completed(HttpResponse result) {
        this.setResponse(result);
        if (this.callback != null) {
            this.callback.completed((Object)result);
        }
    }

    public void failed(Exception exception) {
        this.setThrown(exception);
        if (this.callback != null) {
            this.callback.failed(exception);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.callback != null) {
            this.callback.cancelled();
        }
        return this.getDelegate().cancel(mayInterruptIfRunning);
    }

    public boolean cancel() {
        return this.cancel(true);
    }

    public void cancelled() {
        if (this.callback != null) {
            this.callback.cancelled();
        }
    }

    private synchronized HttpResponse getResponse() {
        return this.response;
    }

    private synchronized void setResponse(HttpResponse response) {
        this.response = response;
    }

    private synchronized Throwable getThrown() {
        return this.thrown;
    }

    private synchronized void setThrown(Throwable thrown) {
        this.thrown = thrown;
    }
}

